%------------------------------------------------------------------------------
% File     : CSR113+19 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_226_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.43 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10928 (   0 equ)
%            Maximal formula atoms :  224 (   1 avg)
%            Number of connectives :  739 (   0   ~;  18   |; 595   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  224 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_226_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_226_a19713,hypothesis,
    ( agt(c1953,c1971)
    & dircl(c1953,c2020)
    & mannr(c1953,spaet_1_1)
    & subs(c1953,kommen_1_1)
    & temp(c1953,c3)
    & attr(c1971,c1972)
    & sub(c1971,stadt__1_1)
    & sub(c1972,name_1_1)
    & val(c1972,madison_0)
    & attr(c1976,c1977)
    & sub(c1976,stadt__1_1)
    & sub(c1977,name_1_1)
    & val(c1977,new_york_0)
    & sub(c1994,gestalt_1_1)
    & attr(c1999,c1994)
    & loc(c1999,c2018)
    & prop(c1999,bloss_1_1)
    & sub(c1999,frau_1_1)
    & attch(c2004,c2008)
    & sub(c2004,naehe_1_1)
    & sub(c2008,freiheitsstatue_1_1)
    & assoc(c2015,c1994)
    & exp(c2015,c1979)
    & semrel(c2015,c1953)
    & subs(c2015,auftauchen_1_1)
    & in(c2018,c2004)
    & flp(c2020,c1976)
    & pred(c3,jahr__1_1)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c1953,da)
    & fact(c1953,real)
    & gener(c1953,sp)
    & sort(c1971,d)
    & sort(c1971,io)
    & card(c1971,int1)
    & etype(c1971,int0)
    & fact(c1971,real)
    & gener(c1971,sp)
    & quant(c1971,one)
    & refer(c1971,det)
    & varia(c1971,con)
    & sort(c2020,l)
    & card(c2020,int1)
    & etype(c2020,int0)
    & fact(c2020,real)
    & gener(c2020,sp)
    & quant(c2020,one)
    & refer(c2020,det)
    & varia(c2020,con)
    & sort(spaet_1_1,mq)
    & sort(kommen_1_1,da)
    & fact(kommen_1_1,real)
    & gener(kommen_1_1,ge)
    & sort(c3,me)
    & sort(c3,oa)
    & sort(c3,ta)
    & card(c3,card_c)
    & etype(c3,etype_c)
    & fact(c3,real)
    & gener(c3,sp)
    & quant(c3,quant_c)
    & refer(c3,indet)
    & varia(c3,varia_c)
    & sort(c1972,na)
    & card(c1972,int1)
    & etype(c1972,int0)
    & fact(c1972,real)
    & gener(c1972,sp)
    & quant(c1972,one)
    & refer(c1972,indet)
    & varia(c1972,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(madison_0,fe)
    & sort(c1976,d)
    & sort(c1976,io)
    & card(c1976,int1)
    & etype(c1976,int0)
    & fact(c1976,real)
    & gener(c1976,sp)
    & quant(c1976,one)
    & refer(c1976,det)
    & varia(c1976,con)
    & sort(c1977,na)
    & card(c1977,int1)
    & etype(c1977,int0)
    & fact(c1977,real)
    & gener(c1977,sp)
    & quant(c1977,one)
    & refer(c1977,indet)
    & varia(c1977,varia_c)
    & sort(new_york_0,fe)
    & sort(c1994,na)
    & card(c1994,int1)
    & etype(c1994,int0)
    & fact(c1994,real)
    & gener(c1994,sp)
    & quant(c1994,one)
    & refer(c1994,det)
    & varia(c1994,con)
    & sort(gestalt_1_1,na)
    & card(gestalt_1_1,int1)
    & etype(gestalt_1_1,int0)
    & fact(gestalt_1_1,real)
    & gener(gestalt_1_1,ge)
    & quant(gestalt_1_1,one)
    & refer(gestalt_1_1,refer_c)
    & varia(gestalt_1_1,varia_c)
    & sort(c1999,d)
    & card(c1999,int1)
    & etype(c1999,int0)
    & fact(c1999,real)
    & gener(c1999,sp)
    & quant(c1999,one)
    & refer(c1999,indet)
    & varia(c1999,varia_c)
    & sort(c2018,l)
    & card(c2018,int1)
    & etype(c2018,int0)
    & fact(c2018,real)
    & gener(c2018,sp)
    & quant(c2018,one)
    & refer(c2018,det)
    & varia(c2018,con)
    & sort(bloss_1_1,tq)
    & sort(frau_1_1,d)
    & card(frau_1_1,int1)
    & etype(frau_1_1,int0)
    & fact(frau_1_1,real)
    & gener(frau_1_1,ge)
    & quant(frau_1_1,one)
    & refer(frau_1_1,refer_c)
    & varia(frau_1_1,varia_c)
    & sort(c2004,d)
    & sort(c2004,io)
    & card(c2004,int1)
    & etype(c2004,int0)
    & fact(c2004,real)
    & gener(c2004,sp)
    & quant(c2004,one)
    & refer(c2004,det)
    & varia(c2004,con)
    & sort(c2008,d)
    & card(c2008,int1)
    & etype(c2008,int0)
    & fact(c2008,real)
    & gener(c2008,sp)
    & quant(c2008,one)
    & refer(c2008,det)
    & varia(c2008,con)
    & sort(naehe_1_1,d)
    & sort(naehe_1_1,io)
    & card(naehe_1_1,int1)
    & etype(naehe_1_1,int0)
    & fact(naehe_1_1,real)
    & gener(naehe_1_1,ge)
    & quant(naehe_1_1,one)
    & refer(naehe_1_1,refer_c)
    & varia(naehe_1_1,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c2015,dn)
    & fact(c2015,real)
    & gener(c2015,sp)
    & sort(c1979,o)
    & card(c1979,int1)
    & etype(c1979,int0)
    & fact(c1979,real)
    & gener(c1979,sp)
    & quant(c1979,one)
    & refer(c1979,det)
    & varia(c1979,varia_c)
    & sort(auftauchen_1_1,dn)
    & fact(auftauchen_1_1,real)
    & gener(auftauchen_1_1,ge)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
