%------------------------------------------------------------------------------
% File     : CSR113+17 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_212_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.43 v7.5.0, 0.48 v7.4.0, 0.44 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.43 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10858 (   0 equ)
%            Maximal formula atoms :  156 (   1 avg)
%            Number of connectives :  669 (   0   ~;  18   |; 525   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  156 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16652 (16652 usr;16651 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_212_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_212_a19713,hypothesis,
    ( sub(c2034,mine_1_3)
    & arg1(c2528,c2549)
    & arg2(c2528,c2034)
    & subs(c2528,stammen_1_2)
    & benf(c2549,c2555)
    & origl(c2549,c2588)
    & sub(c2549,kupfer_1_1)
    & sub(c2555,freiheitsstatue_1_1)
    & pred(c2571,franzose_1_1)
    & agt(c2578,c2571)
    & obj(c2578,c2555)
    & ornt(c2578,c2580)
    & subs(c2578,schenken_1_1)
    & attr(c2580,c2581)
    & sub(c2580,stadt__1_1)
    & sub(c2581,name_1_1)
    & val(c2581,new_york_0)
    & flp(c2588,c2034)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c2034,d)
    & card(c2034,int1)
    & etype(c2034,int0)
    & fact(c2034,real)
    & gener(c2034,sp)
    & quant(c2034,one)
    & refer(c2034,det)
    & varia(c2034,varia_c)
    & sort(mine_1_3,d)
    & card(mine_1_3,int1)
    & etype(mine_1_3,int0)
    & fact(mine_1_3,real)
    & gener(mine_1_3,ge)
    & quant(mine_1_3,one)
    & refer(mine_1_3,refer_c)
    & varia(mine_1_3,varia_c)
    & sort(c2528,st)
    & fact(c2528,real)
    & gener(c2528,sp)
    & sort(c2549,s)
    & card(c2549,int1)
    & etype(c2549,int0)
    & fact(c2549,real)
    & gener(c2549,sp)
    & quant(c2549,one)
    & refer(c2549,det)
    & varia(c2549,con)
    & sort(stammen_1_2,st)
    & fact(stammen_1_2,real)
    & gener(stammen_1_2,ge)
    & sort(c2555,d)
    & card(c2555,int1)
    & etype(c2555,int0)
    & fact(c2555,real)
    & gener(c2555,sp)
    & quant(c2555,one)
    & refer(c2555,det)
    & varia(c2555,con)
    & sort(c2588,l)
    & card(c2588,int1)
    & etype(c2588,int0)
    & fact(c2588,real)
    & gener(c2588,sp)
    & quant(c2588,one)
    & refer(c2588,det)
    & varia(c2588,con)
    & sort(kupfer_1_1,s)
    & card(kupfer_1_1,int1)
    & etype(kupfer_1_1,int0)
    & fact(kupfer_1_1,real)
    & gener(kupfer_1_1,ge)
    & quant(kupfer_1_1,one)
    & refer(kupfer_1_1,refer_c)
    & varia(kupfer_1_1,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c2571,d)
    & card(c2571,cons(x_constant,cons(int1,nil)))
    & etype(c2571,int1)
    & fact(c2571,real)
    & gener(c2571,sp)
    & quant(c2571,mult)
    & refer(c2571,det)
    & varia(c2571,con)
    & sort(franzose_1_1,d)
    & card(franzose_1_1,int1)
    & etype(franzose_1_1,int0)
    & fact(franzose_1_1,real)
    & gener(franzose_1_1,ge)
    & quant(franzose_1_1,one)
    & refer(franzose_1_1,refer_c)
    & varia(franzose_1_1,varia_c)
    & sort(c2578,da)
    & fact(c2578,real)
    & gener(c2578,sp)
    & sort(c2580,d)
    & sort(c2580,io)
    & card(c2580,int1)
    & etype(c2580,int0)
    & fact(c2580,real)
    & gener(c2580,sp)
    & quant(c2580,one)
    & refer(c2580,det)
    & varia(c2580,con)
    & sort(schenken_1_1,da)
    & fact(schenken_1_1,real)
    & gener(schenken_1_1,ge)
    & sort(c2581,na)
    & card(c2581,int1)
    & etype(c2581,int0)
    & fact(c2581,real)
    & gener(c2581,sp)
    & quant(c2581,one)
    & refer(c2581,indet)
    & varia(c2581,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
