%------------------------------------------------------------------------------
% File     : CSR113+16 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_208_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.36 v6.1.0, 0.56 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.44 v4.0.1, 0.42 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10893 (   0 equ)
%            Maximal formula atoms :  189 (   1 avg)
%            Number of connectives :  704 (   0   ~;  18   |; 560   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  189 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   90 (  90 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_208_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_208_a19713,hypothesis,
    ( scar(c24,c33)
    & subs(c24,geh__366ren_1_1)
    & sub(c33,freiheitsstatue_1_1)
    & attch(c41,c33)
    & attr(c41,c42)
    & sub(c41,stadt__1_1)
    & sub(c42,name_1_1)
    & val(c42,new_york_0)
    & loc(c50171,c55271)
    & sub(c50171,insel__1_1)
    & equ(c50180,c50171)
    & arg1(c54369,c50180)
    & arg2(c54369,c50171)
    & assoc(c54369,c7)
    & modl(c54369,nicht_1_1)
    & semrel(c54369,c24)
    & subr(c54369,equ_0)
    & arg1(c55236,c55070)
    & arg2(c55236,c55267)
    & semrel(c55236,c54369)
    & subs(c55236,geh__366ren_1_3)
    & attr(c55267,c55268)
    & sub(c55267,gebietsinstitution_1_1)
    & sub(c55268,name_1_1)
    & val(c55268,new_jersey_0)
    & auf(c55271,c33)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & chsp2(plazieren_1_1,c7)
    & sort(c24,st)
    & fact(c24,real)
    & gener(c24,sp)
    & sort(c33,d)
    & card(c33,int1)
    & etype(c33,int0)
    & fact(c33,real)
    & gener(c33,sp)
    & quant(c33,one)
    & refer(c33,det)
    & varia(c33,con)
    & sort(geh__366ren_1_1,st)
    & fact(geh__366ren_1_1,real)
    & gener(geh__366ren_1_1,ge)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c41,d)
    & sort(c41,io)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,one)
    & refer(c41,det)
    & varia(c41,con)
    & sort(c42,na)
    & card(c42,int1)
    & etype(c42,int0)
    & fact(c42,real)
    & gener(c42,sp)
    & quant(c42,one)
    & refer(c42,indet)
    & varia(c42,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c50171,d)
    & card(c50171,int1)
    & etype(c50171,int0)
    & fact(c50171,real)
    & gener(c50171,sp)
    & quant(c50171,one)
    & refer(c50171,det)
    & varia(c50171,con)
    & sort(c55271,l)
    & card(c55271,int1)
    & etype(c55271,int0)
    & fact(c55271,real)
    & gener(c55271,sp)
    & quant(c55271,one)
    & refer(c55271,det)
    & varia(c55271,varia_c)
    & sort(insel__1_1,d)
    & card(insel__1_1,int1)
    & etype(insel__1_1,int0)
    & fact(insel__1_1,real)
    & gener(insel__1_1,ge)
    & quant(insel__1_1,one)
    & refer(insel__1_1,refer_c)
    & varia(insel__1_1,varia_c)
    & sort(c50180,o)
    & card(c50180,int1)
    & etype(c50180,int0)
    & fact(c50180,real)
    & gener(c50180,sp)
    & quant(c50180,one)
    & refer(c50180,det)
    & varia(c50180,varia_c)
    & sort(c54369,st)
    & fact(c54369,real)
    & gener(c54369,sp)
    & sort(c7,tq)
    & sort(nicht_1_1,md)
    & fact(nicht_1_1,real)
    & gener(nicht_1_1,gener_c)
    & sort(equ_0,st)
    & fact(equ_0,real)
    & gener(equ_0,gener_c)
    & sort(c55236,st)
    & fact(c55236,real)
    & gener(c55236,sp)
    & sort(c55070,o)
    & card(c55070,int1)
    & etype(c55070,int0)
    & fact(c55070,real)
    & gener(c55070,sp)
    & quant(c55070,one)
    & refer(c55070,det)
    & varia(c55070,varia_c)
    & sort(c55267,d)
    & sort(c55267,io)
    & card(c55267,int1)
    & etype(c55267,int0)
    & fact(c55267,real)
    & gener(c55267,sp)
    & quant(c55267,one)
    & refer(c55267,det)
    & varia(c55267,con)
    & sort(geh__366ren_1_3,st)
    & fact(geh__366ren_1_3,real)
    & gener(geh__366ren_1_3,ge)
    & sort(c55268,na)
    & card(c55268,int1)
    & etype(c55268,int0)
    & fact(c55268,real)
    & gener(c55268,sp)
    & quant(c55268,one)
    & refer(c55268,indet)
    & varia(c55268,varia_c)
    & sort(gebietsinstitution_1_1,d)
    & sort(gebietsinstitution_1_1,io)
    & card(gebietsinstitution_1_1,int1)
    & etype(gebietsinstitution_1_1,int0)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,ge)
    & quant(gebietsinstitution_1_1,one)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(new_jersey_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(plazieren_1_1,da)
    & fact(plazieren_1_1,real)
    & gener(plazieren_1_1,ge) ) ).

%------------------------------------------------------------------------------
