%------------------------------------------------------------------------------
% File     : CSR113+15 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_203_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.29 v6.4.0, 0.21 v6.3.0, 0.23 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10856 (   0 equ)
%            Maximal formula atoms :  152 (   1 avg)
%            Number of connectives :  667 (   0   ~;  18   |; 523   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  152 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16650 (16650 usr;16649 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_203_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_203_a19713,hypothesis,
    ( caus(c17,c43)
    & sub(c17,gedanke_1_1)
    & sub(c23,bootshafen_1_1)
    & attch(c30,c23)
    & attr(c30,c31)
    & sub(c30,stadt__1_1)
    & sub(c31,name_1_1)
    & val(c31,new_york_0)
    & sub(c32,freiheitsstatue_1_1)
    & loc(c43,c79)
    & rslt(c43,c32)
    & subs(c43,errichten_1_1)
    & agt(c75,c55)
    & modl(c75,nicht_1_1)
    & semrel(c75,c43)
    & subs(c75,kommen_1_1)
    & in(c79,c23)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c17,as)
    & sort(c17,io)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c43,da)
    & fact(c43,real)
    & gener(c43,sp)
    & sort(gedanke_1_1,as)
    & sort(gedanke_1_1,io)
    & card(gedanke_1_1,int1)
    & etype(gedanke_1_1,int0)
    & fact(gedanke_1_1,real)
    & gener(gedanke_1_1,ge)
    & quant(gedanke_1_1,one)
    & refer(gedanke_1_1,refer_c)
    & varia(gedanke_1_1,varia_c)
    & sort(c23,d)
    & card(c23,int1)
    & etype(c23,int0)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,one)
    & refer(c23,det)
    & varia(c23,con)
    & sort(bootshafen_1_1,d)
    & card(bootshafen_1_1,int1)
    & etype(bootshafen_1_1,int0)
    & fact(bootshafen_1_1,real)
    & gener(bootshafen_1_1,ge)
    & quant(bootshafen_1_1,one)
    & refer(bootshafen_1_1,refer_c)
    & varia(bootshafen_1_1,varia_c)
    & sort(c30,d)
    & sort(c30,io)
    & card(c30,int1)
    & etype(c30,int0)
    & fact(c30,real)
    & gener(c30,sp)
    & quant(c30,one)
    & refer(c30,det)
    & varia(c30,con)
    & sort(c31,na)
    & card(c31,int1)
    & etype(c31,int0)
    & fact(c31,real)
    & gener(c31,sp)
    & quant(c31,one)
    & refer(c31,indet)
    & varia(c31,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c32,d)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,indet)
    & varia(c32,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c79,l)
    & card(c79,int1)
    & etype(c79,int0)
    & fact(c79,real)
    & gener(c79,sp)
    & quant(c79,one)
    & refer(c79,det)
    & varia(c79,con)
    & sort(errichten_1_1,da)
    & fact(errichten_1_1,real)
    & gener(errichten_1_1,ge)
    & sort(c75,da)
    & fact(c75,real)
    & gener(c75,sp)
    & sort(c55,d)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,det)
    & varia(c55,varia_c)
    & sort(nicht_1_1,md)
    & fact(nicht_1_1,real)
    & gener(nicht_1_1,gener_c)
    & sort(kommen_1_1,da)
    & fact(kommen_1_1,real)
    & gener(kommen_1_1,ge)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
