%------------------------------------------------------------------------------
% File     : CSR113+14 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_198_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.33 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.29 v7.4.0, 0.25 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.23 v6.2.0, 0.45 v6.1.0, 0.48 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.50 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10889 (   0 equ)
%            Maximal formula atoms :  184 (   1 avg)
%            Number of connectives :  700 (   0   ~;  18   |; 556   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  184 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_198_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_198_a19713,hypothesis,
    ( assoc(amtszeit__1_1,amt_1_2)
    & sub(amtszeit__1_1,zeit_1_1)
    & pmod(c12,erst_1_1,amtszeit__1_1)
    & pars(c15,c8)
    & attr(c19,c20)
    & sub(c20,jahr__1_1)
    & val(c20,c16)
    & sub(c21,freiheitsstatue_1_1)
    & loc(c29,c41)
    & obj(c29,c21)
    & subs(c29,einweihen_1_2)
    & temp(c29,c19)
    & temp(c29,c8)
    & attr(c37,c38)
    & sub(c37,stadt__1_1)
    & sub(c38,name_1_1)
    & val(c38,new_york_0)
    & in(c41,c37)
    & sub(c8,c12)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(amtszeit__1_1,ta)
    & card(amtszeit__1_1,int1)
    & etype(amtszeit__1_1,int0)
    & fact(amtszeit__1_1,real)
    & gener(amtszeit__1_1,ge)
    & quant(amtszeit__1_1,one)
    & refer(amtszeit__1_1,refer_c)
    & varia(amtszeit__1_1,varia_c)
    & sort(amt_1_2,ad)
    & sort(amt_1_2,io)
    & card(amt_1_2,int1)
    & etype(amt_1_2,int0)
    & fact(amt_1_2,real)
    & gener(amt_1_2,ge)
    & quant(amt_1_2,one)
    & refer(amt_1_2,refer_c)
    & varia(amt_1_2,varia_c)
    & sort(zeit_1_1,ta)
    & card(zeit_1_1,int1)
    & etype(zeit_1_1,int0)
    & fact(zeit_1_1,real)
    & gener(zeit_1_1,ge)
    & quant(zeit_1_1,one)
    & refer(zeit_1_1,refer_c)
    & varia(zeit_1_1,varia_c)
    & sort(c12,ta)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,ge)
    & quant(c12,one)
    & refer(c12,refer_c)
    & varia(c12,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(c15,o)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,varia_c)
    & sort(c8,ta)
    & card(c8,int1)
    & etype(c8,int0)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,one)
    & refer(c8,det)
    & varia(c8,varia_c)
    & sort(c19,t)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,det)
    & varia(c19,con)
    & sort(c20,me)
    & sort(c20,oa)
    & sort(c20,ta)
    & card(c20,card_c)
    & etype(c20,etype_c)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,quant_c)
    & refer(c20,refer_c)
    & varia(c20,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int1886)
    & sort(c21,d)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c29,da)
    & fact(c29,real)
    & gener(c29,sp)
    & sort(c41,l)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,one)
    & refer(c41,det)
    & varia(c41,con)
    & sort(einweihen_1_2,da)
    & fact(einweihen_1_2,real)
    & gener(einweihen_1_2,ge)
    & sort(c37,d)
    & sort(c37,io)
    & card(c37,int1)
    & etype(c37,int0)
    & fact(c37,real)
    & gener(c37,sp)
    & quant(c37,one)
    & refer(c37,det)
    & varia(c37,con)
    & sort(c38,na)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,sp)
    & quant(c38,one)
    & refer(c38,indet)
    & varia(c38,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
