%------------------------------------------------------------------------------
% File     : CSR113+13 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_196_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.76 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10924 (   0 equ)
%            Maximal formula atoms :  221 (   1 avg)
%            Number of connectives :  735 (   0   ~;  18   |; 591   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  221 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_196_a19713,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & val(X1,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_196_a19713,hypothesis,
    ( sub(c11,vortag_1_1)
    & agt(c16,c33)
    & dircl(c16,c72)
    & mannr(c16,spontan_1_1)
    & purp(c16,c63)
    & subs(c16,kommen_1_1)
    & ante(c3,c16)
    & obj(c3,c7)
    & subs(c3,einweihung_1_1)
    & temp(c3,c11)
    & attr(c58,c59)
    & sub(c58,stadt__1_1)
    & sub(c59,name_1_1)
    & val(c59,new_york_0)
    & subs(c63,c66)
    & temp(c63,c69)
    & pmod(c66,erst_1_1,konfettiparade_1_1)
    & attr(c69,c70)
    & sub(c7,freiheitsstatue_1_1)
    & sub(c70,jahr__1_1)
    & val(c70,c65)
    & in(c72,c58)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & assoc(konfettiparade_1_1,konfetti_1_1)
    & subs(konfettiparade_1_1,parade__1_1)
    & sort(c11,ta)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(vortag_1_1,ta)
    & card(vortag_1_1,int1)
    & etype(vortag_1_1,int0)
    & fact(vortag_1_1,real)
    & gener(vortag_1_1,ge)
    & quant(vortag_1_1,one)
    & refer(vortag_1_1,refer_c)
    & varia(vortag_1_1,varia_c)
    & sort(c16,da)
    & fact(c16,real)
    & gener(c16,sp)
    & sort(c33,o)
    & card(c33,int1)
    & etype(c33,int0)
    & fact(c33,real)
    & gener(c33,sp)
    & quant(c33,one)
    & refer(c33,det)
    & varia(c33,varia_c)
    & sort(c72,l)
    & card(c72,int1)
    & etype(c72,int0)
    & fact(c72,real)
    & gener(c72,sp)
    & quant(c72,one)
    & refer(c72,det)
    & varia(c72,con)
    & sort(spontan_1_1,nq)
    & sort(c63,ad)
    & card(c63,int1)
    & etype(c63,int0)
    & fact(c63,real)
    & gener(c63,sp)
    & quant(c63,one)
    & refer(c63,det)
    & varia(c63,con)
    & sort(kommen_1_1,da)
    & fact(kommen_1_1,real)
    & gener(kommen_1_1,ge)
    & sort(c3,ad)
    & card(c3,int1)
    & etype(c3,int0)
    & fact(c3,real)
    & gener(c3,sp)
    & quant(c3,one)
    & refer(c3,det)
    & varia(c3,varia_c)
    & sort(c7,d)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,det)
    & varia(c7,con)
    & sort(einweihung_1_1,ad)
    & card(einweihung_1_1,int1)
    & etype(einweihung_1_1,int0)
    & fact(einweihung_1_1,real)
    & gener(einweihung_1_1,ge)
    & quant(einweihung_1_1,one)
    & refer(einweihung_1_1,refer_c)
    & varia(einweihung_1_1,varia_c)
    & sort(c58,d)
    & sort(c58,io)
    & card(c58,int1)
    & etype(c58,int0)
    & fact(c58,real)
    & gener(c58,sp)
    & quant(c58,one)
    & refer(c58,det)
    & varia(c58,con)
    & sort(c59,na)
    & card(c59,int1)
    & etype(c59,int0)
    & fact(c59,real)
    & gener(c59,sp)
    & quant(c59,one)
    & refer(c59,indet)
    & varia(c59,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c66,ad)
    & card(c66,int1)
    & etype(c66,int0)
    & fact(c66,real)
    & gener(c66,ge)
    & quant(c66,one)
    & refer(c66,refer_c)
    & varia(c66,varia_c)
    & sort(c69,t)
    & card(c69,int1)
    & etype(c69,int0)
    & fact(c69,real)
    & gener(c69,sp)
    & quant(c69,one)
    & refer(c69,det)
    & varia(c69,con)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(konfettiparade_1_1,ad)
    & card(konfettiparade_1_1,int1)
    & etype(konfettiparade_1_1,int0)
    & fact(konfettiparade_1_1,real)
    & gener(konfettiparade_1_1,ge)
    & quant(konfettiparade_1_1,one)
    & refer(konfettiparade_1_1,refer_c)
    & varia(konfettiparade_1_1,varia_c)
    & sort(c70,me)
    & sort(c70,oa)
    & sort(c70,ta)
    & card(c70,card_c)
    & etype(c70,etype_c)
    & fact(c70,real)
    & gener(c70,sp)
    & quant(c70,quant_c)
    & refer(c70,refer_c)
    & varia(c70,varia_c)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c65,nu)
    & card(c65,int1894)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c)
    & sort(konfetti_1_1,o)
    & card(konfetti_1_1,int1)
    & etype(konfetti_1_1,int0)
    & fact(konfetti_1_1,real)
    & gener(konfetti_1_1,ge)
    & quant(konfetti_1_1,one)
    & refer(konfetti_1_1,refer_c)
    & varia(konfetti_1_1,varia_c)
    & sort(parade__1_1,ad)
    & card(parade__1_1,int1)
    & etype(parade__1_1,int0)
    & fact(parade__1_1,real)
    & gener(parade__1_1,ge)
    & quant(parade__1_1,one)
    & refer(parade__1_1,refer_c)
    & varia(parade__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
