%------------------------------------------------------------------------------
% File     : CSR113+12 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_191_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.56 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10847 (   0 equ)
%            Maximal formula atoms :  145 (   1 avg)
%            Number of connectives :  658 (   0   ~;  18   |; 514   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  145 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16649 (16649 usr;16648 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_191_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_191_a19713,hypothesis,
    ( attr(c32104,c32105)
    & sub(c32104,stadt__1_1)
    & sub(c32105,name_1_1)
    & val(c32105,new_york_0)
    & sub(c32114,freiheitsstatue_1_1)
    & sub(c32139,luftschiff_1_1)
    & prop(c32152,n1a_1_1)
    & subs(c32152,empfang_1_1)
    & subs(c32157,parade__1_1)
    & tupl_p7(c32248,c32097,c32104,c32114,c32139,c32152,c32157)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c32104,d)
    & sort(c32104,io)
    & card(c32104,int1)
    & etype(c32104,int0)
    & fact(c32104,real)
    & gener(c32104,sp)
    & quant(c32104,one)
    & refer(c32104,det)
    & varia(c32104,con)
    & sort(c32105,na)
    & card(c32105,int1)
    & etype(c32105,int0)
    & fact(c32105,real)
    & gener(c32105,sp)
    & quant(c32105,one)
    & refer(c32105,indet)
    & varia(c32105,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(c32114,d)
    & card(c32114,int1)
    & etype(c32114,int0)
    & fact(c32114,real)
    & gener(c32114,sp)
    & quant(c32114,one)
    & refer(c32114,det)
    & varia(c32114,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c32139,d)
    & card(c32139,int1)
    & etype(c32139,int0)
    & fact(c32139,real)
    & gener(c32139,sp)
    & quant(c32139,one)
    & refer(c32139,det)
    & varia(c32139,con)
    & sort(luftschiff_1_1,d)
    & card(luftschiff_1_1,int1)
    & etype(luftschiff_1_1,int0)
    & fact(luftschiff_1_1,real)
    & gener(luftschiff_1_1,ge)
    & quant(luftschiff_1_1,one)
    & refer(luftschiff_1_1,refer_c)
    & varia(luftschiff_1_1,varia_c)
    & sort(c32152,ad)
    & card(c32152,int1)
    & etype(c32152,int0)
    & fact(c32152,real)
    & gener(c32152,sp)
    & quant(c32152,one)
    & refer(c32152,indet)
    & varia(c32152,varia_c)
    & sort(n1a_1_1,nq)
    & sort(empfang_1_1,ad)
    & card(empfang_1_1,int1)
    & etype(empfang_1_1,int0)
    & fact(empfang_1_1,real)
    & gener(empfang_1_1,ge)
    & quant(empfang_1_1,one)
    & refer(empfang_1_1,refer_c)
    & varia(empfang_1_1,varia_c)
    & sort(c32157,ad)
    & card(c32157,int1)
    & etype(c32157,int0)
    & fact(c32157,real)
    & gener(c32157,gener_c)
    & quant(c32157,one)
    & refer(c32157,refer_c)
    & varia(c32157,varia_c)
    & sort(parade__1_1,ad)
    & card(parade__1_1,int1)
    & etype(parade__1_1,int0)
    & fact(parade__1_1,real)
    & gener(parade__1_1,ge)
    & quant(parade__1_1,one)
    & refer(parade__1_1,refer_c)
    & varia(parade__1_1,varia_c)
    & sort(c32248,ent)
    & card(c32248,card_c)
    & etype(c32248,etype_c)
    & fact(c32248,real)
    & gener(c32248,gener_c)
    & quant(c32248,quant_c)
    & refer(c32248,refer_c)
    & varia(c32248,varia_c)
    & sort(c32097,o)
    & card(c32097,int1)
    & etype(c32097,int0)
    & fact(c32097,real)
    & gener(c32097,sp)
    & quant(c32097,one)
    & refer(c32097,det)
    & varia(c32097,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
