%------------------------------------------------------------------------------
% File     : CSR113+11 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_184_a19713_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.31 v8.2.0, 0.33 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.38 v7.3.0, 0.29 v7.2.0, 0.17 v7.1.0, 0.25 v7.0.0, 0.50 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.75 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10874 (   0 equ)
%            Maximal formula atoms :  172 (   1 avg)
%            Number of connectives :  685 (   0   ~;  18   |; 541   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  172 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16650 (16650 usr;16649 con; 0-2 aty)
%            Number of variables   :  472 ( 405   !;  67   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_184_a19713,conjecture,
    ? [X0,X1,X2,X3] :
      ( attr(X1,X0)
      & scar(X2,X3)
      & sub(X0,name_1_1)
      & val(X0,new_york_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_184_a19713,hypothesis,
    ( tupl_p6(c145,c46,c51,c64,c87,c94)
    & sub(c46,freiheitsstatue_1_1)
    & sub(c51,geschenk__1_1)
    & attch(c57,c51)
    & attr(c57,c58)
    & sub(c57,land_1_1)
    & sub(c58,name_1_1)
    & val(c58,frankreich_0)
    & attr(c64,c65)
    & sub(c64,land_1_1)
    & sub(c65,name_1_1)
    & val(c65,usa_0)
    & sub(c87,bootshafen_1_1)
    & attr(c94,c95)
    & sub(c94,stadt__1_1)
    & sub(c95,name_1_1)
    & val(c95,new_york_0)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(c145,ent)
    & card(c145,card_c)
    & etype(c145,etype_c)
    & fact(c145,real)
    & gener(c145,gener_c)
    & quant(c145,quant_c)
    & refer(c145,refer_c)
    & varia(c145,varia_c)
    & sort(c46,d)
    & card(c46,int1)
    & etype(c46,int0)
    & fact(c46,real)
    & gener(c46,sp)
    & quant(c46,one)
    & refer(c46,det)
    & varia(c46,con)
    & sort(c51,co)
    & card(c51,card_c)
    & etype(c51,etype_c)
    & fact(c51,real)
    & gener(c51,sp)
    & quant(c51,quant_c)
    & refer(c51,indet)
    & varia(c51,varia_c)
    & sort(c64,d)
    & sort(c64,io)
    & card(c64,int1)
    & etype(c64,int0)
    & fact(c64,real)
    & gener(c64,sp)
    & quant(c64,one)
    & refer(c64,det)
    & varia(c64,con)
    & sort(c87,d)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,det)
    & varia(c87,con)
    & sort(c94,d)
    & sort(c94,io)
    & card(c94,int1)
    & etype(c94,int0)
    & fact(c94,real)
    & gener(c94,sp)
    & quant(c94,one)
    & refer(c94,det)
    & varia(c94,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(geschenk__1_1,co)
    & card(geschenk__1_1,card_c)
    & etype(geschenk__1_1,etype_c)
    & fact(geschenk__1_1,real)
    & gener(geschenk__1_1,ge)
    & quant(geschenk__1_1,quant_c)
    & refer(geschenk__1_1,refer_c)
    & varia(geschenk__1_1,varia_c)
    & sort(c57,d)
    & sort(c57,io)
    & card(c57,int1)
    & etype(c57,int0)
    & fact(c57,real)
    & gener(c57,sp)
    & quant(c57,one)
    & refer(c57,det)
    & varia(c57,con)
    & sort(c58,na)
    & card(c58,int1)
    & etype(c58,int0)
    & fact(c58,real)
    & gener(c58,sp)
    & quant(c58,one)
    & refer(c58,indet)
    & varia(c58,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(frankreich_0,fe)
    & sort(c65,na)
    & card(c65,int1)
    & etype(c65,int0)
    & fact(c65,real)
    & gener(c65,sp)
    & quant(c65,one)
    & refer(c65,indet)
    & varia(c65,varia_c)
    & sort(usa_0,fe)
    & sort(bootshafen_1_1,d)
    & card(bootshafen_1_1,int1)
    & etype(bootshafen_1_1,int0)
    & fact(bootshafen_1_1,real)
    & gener(bootshafen_1_1,ge)
    & quant(bootshafen_1_1,one)
    & refer(bootshafen_1_1,refer_c)
    & varia(bootshafen_1_1,varia_c)
    & sort(c95,na)
    & card(c95,int1)
    & etype(c95,int0)
    & fact(c95,real)
    & gener(c95,sp)
    & quant(c95,one)
    & refer(c95,indet)
    & varia(c95,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(new_york_0,fe)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
