%------------------------------------------------------------------------------
% File     : CSR113+10 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Where can you find the Statue of Liberty?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_003_mira_wp_178_a270_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.21 v7.5.0, 0.38 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.65 v5.2.0, 0.57 v5.0.0, 0.55 v4.1.0, 0.56 v4.0.1, 0.58 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11004 (   0 equ)
%            Maximal formula atoms :  299 (   1 avg)
%            Number of connectives :  815 (   0   ~;  18   |; 671   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  299 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-11 aty)
%            Number of functors    : 16665 (16665 usr;16664 con; 0-2 aty)
%            Number of variables   :  473 ( 405   !;  68   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_003_mira_wp_178_a270,conjecture,
    ? [X0,X1,X2,X3,X4] :
      ( flp(X0,X2)
      & attr(X2,X1)
      & loc(X3,X0)
      & scar(X3,X4)
      & sub(X1,name_1_1)
      & subs(X3,stehen_1_1)
      & val(X1,usa_0) ) ).

fof(ave07_era5_synth_qa07_003_mira_wp_178_a270,hypothesis,
    ( assoc(bundeland_1_1,bund_2_1)
    & sub(bundeland_1_1,gebietsinstitution_1_1)
    & sub(bundeland_1_1,land_1_1)
    & assoc(bunderegierung_1_1,bund_1_1)
    & sub(bunderegierung_1_1,regierung_1_1)
    & sub(c81293,freiheitsstatue_1_1)
    & sub(c81332,insel__1_1)
    & attr(c81339,c81340)
    & sub(c81339,insel__1_1)
    & sub(c81340,name_1_1)
    & val(c81340,liberty_island_0)
    & prop(c81355,amerikanisch__1_1)
    & sub(c81355,bunderegierung_1_1)
    & sub(c81366,national_2_1)
    & sub(c81368,park__1_1)
    & subs(c81373,service_1_1)
    & sub(c81378,enklave_1_1)
    & sub(c81395,bezirk__1_1)
    & attch(c81401,c81395)
    & attr(c81401,c81402)
    & sub(c81401,land_1_1)
    & sub(c81402,name_1_1)
    & val(c81402,usa_0)
    & attr(c81409,c81410)
    & sub(c81409,bundeland_1_1)
    & sub(c81410,name_1_1)
    & val(c81410,new_jersey_0)
    & tupl_p11(c81513,c81293,c81332,c81339,c81355,c81366,c81368,c81373,c81378,c81395,c81409)
    & assoc(freiheitsstatue_1_1,freiheit_1_1)
    & sub(freiheitsstatue_1_1,statue_1_1)
    & sort(bundeland_1_1,d)
    & sort(bundeland_1_1,io)
    & card(bundeland_1_1,int1)
    & etype(bundeland_1_1,int0)
    & fact(bundeland_1_1,real)
    & gener(bundeland_1_1,ge)
    & quant(bundeland_1_1,one)
    & refer(bundeland_1_1,refer_c)
    & varia(bundeland_1_1,varia_c)
    & sort(bund_2_1,d)
    & card(bund_2_1,card_c)
    & etype(bund_2_1,int1)
    & fact(bund_2_1,real)
    & gener(bund_2_1,ge)
    & quant(bund_2_1,quant_c)
    & refer(bund_2_1,refer_c)
    & varia(bund_2_1,varia_c)
    & sort(gebietsinstitution_1_1,ent)
    & card(gebietsinstitution_1_1,card_c)
    & etype(gebietsinstitution_1_1,etype_c)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,gener_c)
    & quant(gebietsinstitution_1_1,quant_c)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(bunderegierung_1_1,d)
    & sort(bunderegierung_1_1,io)
    & card(bunderegierung_1_1,card_c)
    & etype(bunderegierung_1_1,int1)
    & fact(bunderegierung_1_1,real)
    & gener(bunderegierung_1_1,ge)
    & quant(bunderegierung_1_1,quant_c)
    & refer(bunderegierung_1_1,refer_c)
    & varia(bunderegierung_1_1,varia_c)
    & sort(bund_1_1,d)
    & sort(bund_1_1,io)
    & card(bund_1_1,card_c)
    & etype(bund_1_1,int1)
    & fact(bund_1_1,real)
    & gener(bund_1_1,ge)
    & quant(bund_1_1,quant_c)
    & refer(bund_1_1,refer_c)
    & varia(bund_1_1,varia_c)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c81293,d)
    & card(c81293,int1)
    & etype(c81293,int0)
    & fact(c81293,real)
    & gener(c81293,sp)
    & quant(c81293,one)
    & refer(c81293,det)
    & varia(c81293,con)
    & sort(freiheitsstatue_1_1,d)
    & card(freiheitsstatue_1_1,int1)
    & etype(freiheitsstatue_1_1,int0)
    & fact(freiheitsstatue_1_1,real)
    & gener(freiheitsstatue_1_1,ge)
    & quant(freiheitsstatue_1_1,one)
    & refer(freiheitsstatue_1_1,refer_c)
    & varia(freiheitsstatue_1_1,varia_c)
    & sort(c81332,d)
    & card(c81332,int1)
    & etype(c81332,int0)
    & fact(c81332,real)
    & gener(c81332,sp)
    & quant(c81332,one)
    & refer(c81332,det)
    & varia(c81332,con)
    & sort(insel__1_1,d)
    & card(insel__1_1,int1)
    & etype(insel__1_1,int0)
    & fact(insel__1_1,real)
    & gener(insel__1_1,ge)
    & quant(insel__1_1,one)
    & refer(insel__1_1,refer_c)
    & varia(insel__1_1,varia_c)
    & sort(c81339,d)
    & card(c81339,int1)
    & etype(c81339,int0)
    & fact(c81339,real)
    & gener(c81339,sp)
    & quant(c81339,one)
    & refer(c81339,det)
    & varia(c81339,con)
    & sort(c81340,na)
    & card(c81340,int1)
    & etype(c81340,int0)
    & fact(c81340,real)
    & gener(c81340,sp)
    & quant(c81340,one)
    & refer(c81340,indet)
    & varia(c81340,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(liberty_island_0,fe)
    & sort(c81355,d)
    & sort(c81355,io)
    & card(c81355,int1)
    & etype(c81355,int1)
    & fact(c81355,real)
    & gener(c81355,sp)
    & quant(c81355,one)
    & refer(c81355,det)
    & varia(c81355,con)
    & sort(amerikanisch__1_1,nq)
    & sort(c81366,o)
    & card(c81366,int1)
    & etype(c81366,int0)
    & fact(c81366,real)
    & gener(c81366,sp)
    & quant(c81366,one)
    & refer(c81366,det)
    & varia(c81366,con)
    & sort(national_2_1,o)
    & card(national_2_1,int1)
    & etype(national_2_1,int0)
    & fact(national_2_1,real)
    & gener(national_2_1,ge)
    & quant(national_2_1,one)
    & refer(national_2_1,refer_c)
    & varia(national_2_1,varia_c)
    & sort(c81368,d)
    & card(c81368,int1)
    & etype(c81368,int0)
    & fact(c81368,real)
    & gener(c81368,gener_c)
    & quant(c81368,one)
    & refer(c81368,refer_c)
    & varia(c81368,varia_c)
    & sort(park__1_1,d)
    & card(park__1_1,int1)
    & etype(park__1_1,int0)
    & fact(park__1_1,real)
    & gener(park__1_1,ge)
    & quant(park__1_1,one)
    & refer(park__1_1,refer_c)
    & varia(park__1_1,varia_c)
    & sort(c81373,ad)
    & card(c81373,int1)
    & etype(c81373,int0)
    & fact(c81373,real)
    & gener(c81373,gener_c)
    & quant(c81373,one)
    & refer(c81373,refer_c)
    & varia(c81373,varia_c)
    & sort(service_1_1,ad)
    & card(service_1_1,int1)
    & etype(service_1_1,int0)
    & fact(service_1_1,real)
    & gener(service_1_1,ge)
    & quant(service_1_1,one)
    & refer(service_1_1,refer_c)
    & varia(service_1_1,varia_c)
    & sort(c81378,d)
    & card(c81378,int1)
    & etype(c81378,int0)
    & fact(c81378,real)
    & gener(c81378,gener_c)
    & quant(c81378,one)
    & refer(c81378,refer_c)
    & varia(c81378,varia_c)
    & sort(enklave_1_1,d)
    & card(enklave_1_1,int1)
    & etype(enklave_1_1,int0)
    & fact(enklave_1_1,real)
    & gener(enklave_1_1,ge)
    & quant(enklave_1_1,one)
    & refer(enklave_1_1,refer_c)
    & varia(enklave_1_1,varia_c)
    & sort(c81395,d)
    & card(c81395,int1)
    & etype(c81395,int0)
    & fact(c81395,real)
    & gener(c81395,sp)
    & quant(c81395,one)
    & refer(c81395,det)
    & varia(c81395,con)
    & sort(bezirk__1_1,d)
    & card(bezirk__1_1,int1)
    & etype(bezirk__1_1,int0)
    & fact(bezirk__1_1,real)
    & gener(bezirk__1_1,ge)
    & quant(bezirk__1_1,one)
    & refer(bezirk__1_1,refer_c)
    & varia(bezirk__1_1,varia_c)
    & sort(c81401,d)
    & sort(c81401,io)
    & card(c81401,int1)
    & etype(c81401,int0)
    & fact(c81401,real)
    & gener(c81401,sp)
    & quant(c81401,one)
    & refer(c81401,det)
    & varia(c81401,con)
    & sort(c81402,na)
    & card(c81402,int1)
    & etype(c81402,int0)
    & fact(c81402,real)
    & gener(c81402,sp)
    & quant(c81402,one)
    & refer(c81402,indet)
    & varia(c81402,varia_c)
    & sort(usa_0,fe)
    & sort(c81409,d)
    & sort(c81409,io)
    & card(c81409,int1)
    & etype(c81409,int0)
    & fact(c81409,real)
    & gener(c81409,sp)
    & quant(c81409,one)
    & refer(c81409,det)
    & varia(c81409,con)
    & sort(c81410,na)
    & card(c81410,int1)
    & etype(c81410,int0)
    & fact(c81410,real)
    & gener(c81410,sp)
    & quant(c81410,one)
    & refer(c81410,indet)
    & varia(c81410,varia_c)
    & sort(new_jersey_0,fe)
    & sort(c81513,ent)
    & card(c81513,card_c)
    & etype(c81513,etype_c)
    & fact(c81513,real)
    & gener(c81513,gener_c)
    & quant(c81513,quant_c)
    & refer(c81513,refer_c)
    & varia(c81513,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(statue_1_1,d)
    & card(statue_1_1,int1)
    & etype(statue_1_1,int0)
    & fact(statue_1_1,real)
    & gener(statue_1_1,ge)
    & quant(statue_1_1,one)
    & refer(statue_1_1,refer_c)
    & varia(statue_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
