%------------------------------------------------------------------------------
% File     : CSR112+1 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who is the singer of the band U2?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_001_qapn_4_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.43 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.57 v6.4.0, 0.43 v6.3.0, 0.46 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.75 v5.5.0, 0.71 v5.4.0, 0.74 v5.3.0, 0.78 v5.2.0, 0.64 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10873 (   0 equ)
%            Maximal formula atoms :  166 (   1 avg)
%            Number of connectives :  684 (   0   ~;  18   |; 540   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  166 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-9 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  476 ( 405   !;  71   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_001_qapn_4,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7] :
      ( arg1(X4,X5)
      & arg2(X4,X0)
      & attr(X7,X6)
      & pred(X2,linie_1_1)
      & pred(X3,u1_1_1)
      & sub(X1,bahn_1_1)
      & sub(X6,name_1_1)
      & subs(X4,hei__337en_1_1)
      & val(X6,u2_0) ) ).

fof(ave07_era5_synth_qa07_001_qapn_4,hypothesis,
    ( sub(c5909,bahn_1_1)
    & pred(c5910,linie_1_1)
    & pred(c5912,u1_1_1)
    & attr(c5919,c5920)
    & sub(c5919,einrichtung_1_2)
    & sub(c5920,name_1_1)
    & val(c5920,u2_0)
    & pred(c5921,u3_1_1)
    & sub(c5932,abstand_1_1)
    & pred(c5937,minute_1_1)
    & tupl_p9(c6138,c5901,c5909,c5910,c5912,c5919,c5921,c5932,c5937)
    & sort(c5909,io)
    & card(c5909,int1)
    & etype(c5909,int0)
    & fact(c5909,real)
    & gener(c5909,gener_c)
    & quant(c5909,one)
    & refer(c5909,refer_c)
    & varia(c5909,varia_c)
    & sort(bahn_1_1,io)
    & card(bahn_1_1,int1)
    & etype(bahn_1_1,int0)
    & fact(bahn_1_1,real)
    & gener(bahn_1_1,ge)
    & quant(bahn_1_1,one)
    & refer(bahn_1_1,refer_c)
    & varia(bahn_1_1,varia_c)
    & sort(c5910,d)
    & sort(c5910,io)
    & card(c5910,cons(x_constant,cons(int1,nil)))
    & etype(c5910,int1)
    & fact(c5910,real)
    & gener(c5910,gener_c)
    & quant(c5910,mult)
    & refer(c5910,indet)
    & varia(c5910,varia_c)
    & sort(linie_1_1,d)
    & sort(linie_1_1,io)
    & card(linie_1_1,int1)
    & etype(linie_1_1,int0)
    & fact(linie_1_1,real)
    & gener(linie_1_1,ge)
    & quant(linie_1_1,one)
    & refer(linie_1_1,refer_c)
    & varia(linie_1_1,varia_c)
    & sort(c5912,o)
    & card(c5912,cons(x_constant,cons(int1,nil)))
    & etype(c5912,int1)
    & fact(c5912,real)
    & gener(c5912,gener_c)
    & quant(c5912,mult)
    & refer(c5912,indet)
    & varia(c5912,varia_c)
    & sort(u1_1_1,o)
    & card(u1_1_1,int1)
    & etype(u1_1_1,int0)
    & fact(u1_1_1,real)
    & gener(u1_1_1,ge)
    & quant(u1_1_1,one)
    & refer(u1_1_1,refer_c)
    & varia(u1_1_1,varia_c)
    & sort(c5919,d)
    & sort(c5919,io)
    & card(c5919,int1)
    & etype(c5919,int1)
    & fact(c5919,real)
    & gener(c5919,sp)
    & quant(c5919,one)
    & refer(c5919,det)
    & varia(c5919,con)
    & sort(c5920,na)
    & card(c5920,int1)
    & etype(c5920,int0)
    & fact(c5920,real)
    & gener(c5920,sp)
    & quant(c5920,one)
    & refer(c5920,indet)
    & varia(c5920,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(u2_0,fe)
    & sort(c5921,o)
    & card(c5921,cons(x_constant,cons(int1,nil)))
    & etype(c5921,int1)
    & fact(c5921,real)
    & gener(c5921,gener_c)
    & quant(c5921,mult)
    & refer(c5921,indet)
    & varia(c5921,varia_c)
    & sort(u3_1_1,o)
    & card(u3_1_1,int1)
    & etype(u3_1_1,int0)
    & fact(u3_1_1,real)
    & gener(u3_1_1,ge)
    & quant(u3_1_1,one)
    & refer(u3_1_1,refer_c)
    & varia(u3_1_1,varia_c)
    & sort(c5932,io)
    & sort(c5932,na)
    & card(c5932,int1)
    & etype(c5932,int0)
    & fact(c5932,real)
    & gener(c5932,sp)
    & quant(c5932,one)
    & refer(c5932,det)
    & varia(c5932,con)
    & sort(abstand_1_1,io)
    & sort(abstand_1_1,na)
    & card(abstand_1_1,int1)
    & etype(abstand_1_1,int0)
    & fact(abstand_1_1,real)
    & gener(abstand_1_1,ge)
    & quant(abstand_1_1,one)
    & refer(abstand_1_1,refer_c)
    & varia(abstand_1_1,varia_c)
    & sort(c5937,me)
    & sort(c5937,oa)
    & sort(c5937,ta)
    & card(c5937,card_c)
    & etype(c5937,etype_c)
    & fact(c5937,real)
    & gener(c5937,gener_c)
    & quant(c5937,quant_c)
    & refer(c5937,refer_c)
    & varia(c5937,varia_c)
    & sort(minute_1_1,me)
    & sort(minute_1_1,oa)
    & sort(minute_1_1,ta)
    & card(minute_1_1,card_c)
    & etype(minute_1_1,etype_c)
    & fact(minute_1_1,real)
    & gener(minute_1_1,ge)
    & quant(minute_1_1,quant_c)
    & refer(minute_1_1,refer_c)
    & varia(minute_1_1,varia_c)
    & sort(c6138,ent)
    & card(c6138,card_c)
    & etype(c6138,etype_c)
    & fact(c6138,real)
    & gener(c6138,gener_c)
    & quant(c6138,quant_c)
    & refer(c6138,refer_c)
    & varia(c6138,varia_c)
    & sort(c5901,o)
    & card(c5901,int1)
    & etype(c5901,int0)
    & fact(c5901,real)
    & gener(c5901,sp)
    & quant(c5901,one)
    & refer(c5901,det)
    & varia(c5901,varia_c) ) ).

%------------------------------------------------------------------------------
