%------------------------------------------------------------------------------
% File     : CSR109+7 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Skolemization of a deep class hierarchy, with subsumption
% Version  : Especial.
%            Theorem formulation : Existentially quantified, as a question.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG50

% Status   : ContradictoryAxioms
% Rating   : 0.70 v9.0.0, 0.75 v8.2.0, 0.69 v8.1.0, 0.78 v7.4.0, 0.29 v7.3.0
% Syntax   : Number of formulae    : 55589 (40662 unt;   0 def)
%            Number of atoms       : 151001 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99418 (4006   ~; 275   |;60357   &)
%                                         ( 249 <=>;34531  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33067 (32450 usr;32839 con; 0-8 aty)
%            Number of variables   : 56945 (49181   !;7764   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : Requires at least 53 steps. 
% Bugfixes : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Creature50_1,s__Animal) ).

fof(local_2,axiom,
    ( s__subclass(s__Reptile,s__Animal)
   => ? [V_C1,V_C2,V_C3,V_C4,V_C5,V_C6,V_C7,V_C8,V_C9,V_C10] :
        ( s__instance(V_C1,s__SetOrClass)
        & s__instance(V_C2,s__SetOrClass)
        & s__instance(V_C3,s__SetOrClass)
        & s__instance(V_C4,s__SetOrClass)
        & s__instance(V_C5,s__SetOrClass)
        & s__instance(V_C6,s__SetOrClass)
        & s__instance(V_C7,s__SetOrClass)
        & s__instance(V_C8,s__SetOrClass)
        & s__instance(V_C9,s__SetOrClass)
        & s__instance(V_C10,s__SetOrClass)
        & s__subclass(V_C1,V_C2)
        & s__subclass(V_C2,V_C3)
        & s__subclass(V_C3,V_C4)
        & s__subclass(V_C4,V_C5)
        & s__subclass(V_C5,V_C6)
        & s__subclass(V_C6,V_C7)
        & s__subclass(V_C7,V_C8)
        & s__subclass(V_C8,V_C9)
        & s__subclass(V_C9,V_C10)
        & s__subclass(V_C10,s__Reptile)
        & s__instance(s__Creature50_1,V_C1) ) ) ).

fof(prove_from_SUMO_MILO,conjecture,
    ? [X__s__Creature50_1] : s__instance(X__s__Creature50_1,s__Reptile) ).

%------------------------------------------------------------------------------
