%------------------------------------------------------------------------------
% File     : CSR107+4 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Temporal point and interval reasoning
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG38

% Status   : ContradictoryAxioms
% Rating   : 0.79 v9.0.0, 0.83 v7.5.0, 0.88 v7.4.0, 0.71 v7.3.0
% Syntax   : Number of formulae    : 7228 (4501 unt;   0 def)
%            Number of atoms       : 18030 (1090 equ)
%            Maximal formula atoms :   22 (   2 avg)
%            Number of connectives : 11358 ( 556   ~;  70   |;4876   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3174 (3123 usr;3061 con; 0-8 aty)
%            Number of variables   : 7498 (7003   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TimeInterval38_1,s__TimeInterval) ).

fof(local_2,axiom,
    s__instance(s__TimeInterval38_2,s__TimeInterval) ).

fof(local_3,axiom,
    s__instance(s__TimeInterval38_3,s__TimeInterval) ).

fof(local_4,axiom,
    s__earlier(s__TimeInterval38_1,s__TimeInterval38_2) ).

fof(local_5,axiom,
    s__instance(s__TimePoint38_1,s__TimePoint) ).

fof(local_6,axiom,
    s__instance(s__TimePoint38_2,s__TimePoint) ).

fof(local_7,axiom,
    s__temporalPart(s__TimePoint38_1,s__TimeInterval38_1) ).

fof(local_8,axiom,
    s__temporalPart(s__TimePoint38_1,s__TimeInterval38_3) ).

fof(local_9,axiom,
    s__temporalPart(s__TimePoint38_2,s__TimeInterval38_2) ).

fof(local_10,axiom,
    s__temporalPart(s__TimePoint38_2,s__TimeInterval38_3) ).

fof(prove_from_SUMO,conjecture,
    ( s__overlapsTemporally(s__TimeInterval38_3,s__TimeInterval38_1)
    & s__overlapsTemporally(s__TimeInterval38_3,s__TimeInterval38_2) ) ).

%------------------------------------------------------------------------------
