%------------------------------------------------------------------------------
% File     : CSR106+3 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Temporal point and interval reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG37

% Status   : ContradictoryAxioms
% Rating   : 0.97 v7.5.0, 0.94 v7.4.0, 0.71 v7.3.0
% Syntax   : Number of formulae    : 145109 (130183 unt;   0 def)
%            Number of atoms       : 240500 (14168 equ)
%            Maximal formula atoms :   29 (   1 avg)
%            Number of connectives : 99398 (4007   ~; 275   |;60337   &)
%                                         ( 249 <=>;34530  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   2 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33070 (32453 usr;32842 con; 0-8 aty)
%            Number of variables   : 56934 (49181   !;7753   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v3.4.1 - Bugfixes in CSR003+*.ax
%          : v3.4.2 - Bugfixes in CSR003+1.ax, CSR003+3.ax, CSR003+10.ax
%          : v3.5.0 - Bugfixes in CSR003+1.ax
%          : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%----Include cache axioms for all Sigma constituents
include('Axioms/CSR003+5.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TimeInterval37_1,s__TimeInterval) ).

fof(local_2,axiom,
    s__instance(s__TimeInterval37_2,s__TimeInterval) ).

fof(local_3,axiom,
    s__earlier(s__TimeInterval37_1,s__TimeInterval37_2) ).

fof(local_4,axiom,
    s__instance(s__TimePoint37_1,s__TimePoint) ).

fof(local_5,axiom,
    s__instance(s__TimePoint37_2,s__TimePoint) ).

fof(local_6,axiom,
    s__temporalPart(s__TimePoint37_1,s__TimeInterval37_1) ).

fof(local_7,axiom,
    s__temporalPart(s__TimePoint37_2,s__TimeInterval37_2) ).

fof(prove_from_ALL,conjecture,
    ~ s__before(s__TimePoint37_2,s__TimePoint37_1) ).

%------------------------------------------------------------------------------
