%------------------------------------------------------------------------------
% File     : CSR106+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Temporal point and interval reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG37

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.0.0, 0.83 v8.2.0, 0.86 v8.1.0, 0.92 v7.5.0, 0.88 v7.4.0, 0.29 v7.3.0
% Syntax   : Number of formulae    : 14795 (12069 unt;   0 def)
%            Number of atoms       : 25596 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11358 ( 557   ~;  70   |;4875   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3173 (3122 usr;3060 con; 0-8 aty)
%            Number of variables   : 7498 (7003   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TimeInterval37_1,s__TimeInterval) ).

fof(local_2,axiom,
    s__instance(s__TimeInterval37_2,s__TimeInterval) ).

fof(local_3,axiom,
    s__earlier(s__TimeInterval37_1,s__TimeInterval37_2) ).

fof(local_4,axiom,
    s__instance(s__TimePoint37_1,s__TimePoint) ).

fof(local_5,axiom,
    s__instance(s__TimePoint37_2,s__TimePoint) ).

fof(local_6,axiom,
    s__temporalPart(s__TimePoint37_1,s__TimeInterval37_1) ).

fof(local_7,axiom,
    s__temporalPart(s__TimePoint37_2,s__TimeInterval37_2) ).

fof(prove_from_SUMO,conjecture,
    ~ s__before(s__TimePoint37_2,s__TimePoint37_1) ).

%------------------------------------------------------------------------------
