%------------------------------------------------------------------------------
% File     : CSR105+7 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Temporal interval reasoning
% Version  : Especial.
%            Theorem formulation : Existentially quantified, as a question.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG36

% Status   : ContradictoryAxioms
% Rating   : 0.55 v9.1.0, 0.61 v9.0.0, 0.56 v8.1.0, 0.64 v7.5.0, 0.69 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 55592 (40666 unt;   0 def)
%            Number of atoms       : 150983 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99397 (4006   ~; 275   |;60337   &)
%                                         ( 249 <=>;34530  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33069 (32452 usr;32841 con; 0-8 aty)
%            Number of variables   : 56936 (49181   !;7755   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TimeInterval36_1,s__TimeInterval) ).

fof(local_2,axiom,
    s__instance(s__TimeInterval36_2,s__TimeInterval) ).

fof(local_3,axiom,
    s__instance(s__TimeInterval36_3,s__TimeInterval) ).

fof(local_4,axiom,
    s__starts(s__TimeInterval36_1,s__TimeInterval36_3) ).

fof(local_5,axiom,
    s__starts(s__TimeInterval36_2,s__TimeInterval36_3) ).

fof(prove_from_ALL,conjecture,
    ? [X__s__TimeInterval36_1,X__s__TimeInterval36_2] : s__overlapsTemporally(X__s__TimeInterval36_1,X__s__TimeInterval36_2) ).

%------------------------------------------------------------------------------
