%------------------------------------------------------------------------------
% File     : CSR104+2 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Temporal point and interval reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG35

% Status   : ContradictoryAxioms
% Rating   : 0.73 v9.0.0, 0.75 v8.2.0, 0.72 v8.1.0, 0.75 v7.5.0, 0.84 v7.4.0, 0.14 v7.3.0
% Syntax   : Number of formulae    : 37987 (32652 unt;   0 def)
%            Number of atoms       : 59783 (1489 equ)
%            Maximal formula atoms :   23 (   1 avg)
%            Number of connectives : 22719 ( 923   ~; 115   |;10359   &)
%                                         ( 137 <=>;11185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9430 (8983 usr;9295 con; 0-8 aty)
%            Number of variables   : 13110 (11617   !;1493   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v3.4.1 - Bugfixes in CSR003+*.ax
%          : v3.4.2 - Bugfixes in CSR003+1.ax
%          : v3.5.0 - Bugfixes in CSR003+1.ax
%          : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%----Include cache axioms for SUMO+MILO
include('Axioms/CSR003+4.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TimePoint35_1,s__TimePoint) ).

fof(local_2,axiom,
    s__instance(s__TimeInterval35_1,s__TimeInterval) ).

fof(local_3,axiom,
    s__instance(s__TimeInterval35_2,s__TimeInterval) ).

fof(local_4,axiom,
    s__temporalPart(s__TimePoint35_1,s__TimeInterval35_1) ).

fof(local_5,axiom,
    s__during(s__TimeInterval35_1,s__TimeInterval35_2) ).

fof(prove_from_SUMO_MILO,conjecture,
    s__temporalPart(s__TimePoint35_1,s__TimeInterval35_2) ).

%------------------------------------------------------------------------------
