%------------------------------------------------------------------------------
% File     : CSR102+5 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Every physical object has some positive mass
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG33

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.1.0, 0.88 v9.0.0, 0.86 v8.2.0, 0.89 v8.1.0, 0.92 v7.5.0, 0.88 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 16750 (11414 unt;   0 def)
%            Number of atoms       : 38547 (1489 equ)
%            Maximal formula atoms :   23 (   2 avg)
%            Number of connectives : 22720 ( 923   ~; 115   |;10360   &)
%                                         ( 137 <=>;11185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9429 (8982 usr;9294 con; 0-8 aty)
%            Number of variables   : 13111 (11617   !;1494   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Animal33_1,s__Animal) ).

fof(prove_from_SUMO_MILO,conjecture,
    ? [V_X] :
      ( greater(V_X,n0)
      & s__weight(s__Animal33_1,s__MeasureFn(V_X,s__PoundMass)) ) ).

%------------------------------------------------------------------------------
