%------------------------------------------------------------------------------
% File     : CSR102+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Every physical object has some positive mass
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG33

% Status   : ContradictoryAxioms
% Rating   : 0.88 v9.1.0, 0.85 v9.0.0, 0.83 v8.2.0, 0.86 v8.1.0, 0.92 v7.5.0, 0.84 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 14789 (12062 unt;   0 def)
%            Number of atoms       : 25591 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11358 ( 556   ~;  70   |;4876   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3171 (3120 usr;3058 con; 0-8 aty)
%            Number of variables   : 7499 (7003   !; 496   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Animal33_1,s__Animal) ).

fof(prove_from_SUMO,conjecture,
    ? [V_X] :
      ( greater(V_X,n0)
      & s__weight(s__Animal33_1,s__MeasureFn(V_X,s__PoundMass)) ) ).

%------------------------------------------------------------------------------
