%------------------------------------------------------------------------------
% File     : CSR101+5 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : An "intensional" query requiring circular subclass reasoning
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG32

% Status   : ContradictoryAxioms
% Rating   : 0.67 v8.2.0, 0.64 v8.1.0, 0.67 v7.5.0, 0.75 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 16758 (11422 unt;   0 def)
%            Number of atoms       : 38555 (1489 equ)
%            Maximal formula atoms :   23 (   2 avg)
%            Number of connectives : 22720 ( 923   ~; 115   |;10359   &)
%                                         ( 137 <=>;11186  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9430 (8983 usr;9295 con; 0-8 aty)
%            Number of variables   : 13111 (11618   !;1493   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Class32_1,s__Class) ).

fof(local_2,axiom,
    s__instance(s__Class32_2,s__Class) ).

fof(local_3,axiom,
    s__instance(s__Class32_3,s__Class) ).

fof(local_4,axiom,
    s__subclass(s__Class32_1,s__Animal) ).

fof(local_5,axiom,
    s__subclass(s__Class32_2,s__Animal) ).

fof(local_6,axiom,
    s__subclass(s__Class32_3,s__Animal) ).

fof(local_7,axiom,
    s__subclass(s__Class32_1,s__Class32_2) ).

fof(local_8,axiom,
    s__subclass(s__Class32_2,s__Class32_3) ).

fof(local_9,axiom,
    s__subclass(s__Class32_3,s__Class32_1) ).

fof(prove_from_SUMO_MILO,conjecture,
    ! [V_X] :
      ( s__instance(V_X,s__Class32_2)
     => s__instance(V_X,s__Class32_1) ) ).

%------------------------------------------------------------------------------
