%------------------------------------------------------------------------------
% File     : CSR101+3 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : An "intensional" query requiring circular subclass reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG32

% Status   : ContradictoryAxioms
% Rating   : 0.73 v9.0.0, 0.75 v8.2.0, 0.78 v8.1.0, 0.83 v7.5.0, 0.81 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 145111 (130184 unt;   0 def)
%            Number of atoms       : 240503 (14168 equ)
%            Maximal formula atoms :   29 (   1 avg)
%            Number of connectives : 99398 (4006   ~; 275   |;60337   &)
%                                         ( 249 <=>;34531  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   2 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33069 (32452 usr;32841 con; 0-8 aty)
%            Number of variables   : 56935 (49182   !;7753   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v3.4.1 - Bugfixes in CSR003+*.ax
%          : v3.4.2 - Bugfixes in CSR003+1.ax, CSR003+3.ax, CSR003+10.ax
%          : v3.5.0 - Bugfixes in CSR003+1.ax
%          : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%----Include cache axioms for all Sigma constituents
include('Axioms/CSR003+5.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Class32_1,s__Class) ).

fof(local_2,axiom,
    s__instance(s__Class32_2,s__Class) ).

fof(local_3,axiom,
    s__instance(s__Class32_3,s__Class) ).

fof(local_4,axiom,
    s__subclass(s__Class32_1,s__Animal) ).

fof(local_5,axiom,
    s__subclass(s__Class32_2,s__Animal) ).

fof(local_6,axiom,
    s__subclass(s__Class32_3,s__Animal) ).

fof(local_7,axiom,
    s__subclass(s__Class32_1,s__Class32_2) ).

fof(local_8,axiom,
    s__subclass(s__Class32_2,s__Class32_3) ).

fof(local_9,axiom,
    s__subclass(s__Class32_3,s__Class32_1) ).

fof(prove_from_ALL,conjecture,
    ! [V_X] :
      ( s__instance(V_X,s__Class32_2)
     => s__instance(V_X,s__Class32_1) ) ).

%------------------------------------------------------------------------------
