%------------------------------------------------------------------------------
% File     : CSR101+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : An "intensional" query requiring circular subclass reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG32

% Status   : ContradictoryAxioms
% Rating   : 0.67 v8.2.0, 0.61 v8.1.0, 0.67 v7.5.0, 0.75 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 14797 (12070 unt;   0 def)
%            Number of atoms       : 25599 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11358 ( 556   ~;  70   |;4875   &)
%                                         ( 100 <=>;5757  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3172 (3121 usr;3059 con; 0-8 aty)
%            Number of variables   : 7499 (7004   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Class32_1,s__Class) ).

fof(local_2,axiom,
    s__instance(s__Class32_2,s__Class) ).

fof(local_3,axiom,
    s__instance(s__Class32_3,s__Class) ).

fof(local_4,axiom,
    s__subclass(s__Class32_1,s__Animal) ).

fof(local_5,axiom,
    s__subclass(s__Class32_2,s__Animal) ).

fof(local_6,axiom,
    s__subclass(s__Class32_3,s__Animal) ).

fof(local_7,axiom,
    s__subclass(s__Class32_1,s__Class32_2) ).

fof(local_8,axiom,
    s__subclass(s__Class32_2,s__Class32_3) ).

fof(local_9,axiom,
    s__subclass(s__Class32_3,s__Class32_1) ).

fof(prove_from_SUMO,conjecture,
    ! [V_X] :
      ( s__instance(V_X,s__Class32_2)
     => s__instance(V_X,s__Class32_1) ) ).

%------------------------------------------------------------------------------
