%------------------------------------------------------------------------------
% File     : CSR100+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Circular subclass subsumption reasoning
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG31

% Status   : ContradictoryAxioms
% Rating   : 0.64 v9.0.0, 0.67 v8.2.0, 0.58 v8.1.0, 0.67 v7.5.0, 0.75 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 14798 (12072 unt;   0 def)
%            Number of atoms       : 25599 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11357 ( 556   ~;  70   |;4875   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3173 (3122 usr;3060 con; 0-8 aty)
%            Number of variables   : 7498 (7003   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Class31_1,s__Class) ).

fof(local_2,axiom,
    s__instance(s__Class31_2,s__Class) ).

fof(local_3,axiom,
    s__instance(s__Class31_3,s__Class) ).

fof(local_4,axiom,
    s__subclass(s__Class31_1,s__Animal) ).

fof(local_5,axiom,
    s__subclass(s__Class31_2,s__Animal) ).

fof(local_6,axiom,
    s__subclass(s__Class31_3,s__Animal) ).

fof(local_7,axiom,
    s__subclass(s__Class31_1,s__Class31_2) ).

fof(local_8,axiom,
    s__subclass(s__Class31_2,s__Class31_3) ).

fof(local_9,axiom,
    s__subclass(s__Class31_3,s__Class31_1) ).

fof(local_10,axiom,
    s__instance(s__Animal31,s__Class31_2) ).

fof(prove_from_SUMO,conjecture,
    s__instance(s__Animal31,s__Class31_1) ).

%------------------------------------------------------------------------------
