%------------------------------------------------------------------------------
% File     : CSR097+5 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : A gaseous object
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG28

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.1.0, 0.88 v9.0.0, 0.89 v8.1.0, 0.92 v7.5.0, 0.88 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 16758 (11423 unt;   0 def)
%            Number of atoms       : 38554 (1489 equ)
%            Maximal formula atoms :   23 (   2 avg)
%            Number of connectives : 22720 ( 924   ~; 115   |;10359   &)
%                                         ( 137 <=>;11185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9433 (8986 usr;9298 con; 0-8 aty)
%            Number of variables   : 13110 (11617   !;1493   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Planet28_1,s__Class) ).

fof(local_2,axiom,
    s__subclass(s__Planet28_1,s__AstronomicalBody) ).

fof(local_3,axiom,
    s__instance(s__Rocky,s__Attribute) ).

fof(local_4,axiom,
    s__instance(s__Icy,s__Attribute) ).

fof(local_5,axiom,
    s__instance(s__Watery,s__Attribute) ).

fof(local_6,axiom,
    s__instance(s__Gaseous,s__Attribute) ).

fof(local_7,axiom,
    s__contraryAttribute_4(s__Rocky,s__Icy,s__Watery,s__Gaseous) ).

fof(local_8,axiom,
    s__instance(s__Object28_1,s__Planet28_1) ).

fof(local_9,axiom,
    s__attribute(s__Object28_1,s__Watery) ).

fof(prove_from_SUMO_MILO,conjecture,
    ~ s__attribute(s__Object28_1,s__Gaseous) ).

%------------------------------------------------------------------------------
