%------------------------------------------------------------------------------
% File     : CSR096+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Case elimination
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG26

% Status   : ContradictoryAxioms
% Rating   : 0.76 v9.0.0, 0.78 v8.2.0, 0.72 v7.5.0, 0.78 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 14795 (12066 unt;   0 def)
%            Number of atoms       : 25605 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11368 ( 558   ~;  72   |;4876   &)
%                                         ( 100 <=>;5762  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3174 (3123 usr;3061 con; 0-8 aty)
%            Number of variables   : 7501 (7006   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Planet26_1,s__Class) ).

fof(local_2,axiom,
    s__subclass(s__Planet26_1,s__AstronomicalBody) ).

fof(local_3,axiom,
    ! [V_P] :
      ( s__instance(V_P,s__Object)
     => ( s__instance(V_P,s__Planet26_1)
       => ( s__attribute(V_P,s__Solid)
          | s__attribute(V_P,s__Gaseous) ) ) ) ).

fof(local_4,axiom,
    ! [V_P] :
      ( s__instance(V_P,s__Object)
     => ( s__instance(V_P,s__Planet26_1)
       => ( s__attribute(V_P,s__Earthlike)
          | s__attribute(V_P,s__HostileToEarthLife) ) ) ) ).

fof(local_5,axiom,
    ! [V_X] :
      ( s__instance(V_X,s__Object)
     => ( ( s__instance(V_X,s__Planet26_1)
          & s__attribute(V_X,s__Gaseous) )
       => ~ s__attribute(V_X,s__Earthlike) ) ) ).

fof(local_6,axiom,
    s__instance(s__Object26_1,s__Planet26_1) ).

fof(local_7,axiom,
    ~ s__attribute(s__Object26_1,s__Solid) ).

fof(prove_from_SUMO,conjecture,
    s__attribute(s__Object26_1,s__HostileToEarthLife) ).

%------------------------------------------------------------------------------
