%------------------------------------------------------------------------------
% File     : CSR093+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Distant ancestry
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG23

% Status   : ContradictoryAxioms
% Rating   : 0.76 v9.0.0, 0.78 v8.2.0, 0.75 v8.1.0, 0.81 v7.5.0, 0.84 v7.4.0, 0.14 v7.3.0
% Syntax   : Number of formulae    : 14819 (12092 unt;   0 def)
%            Number of atoms       : 25621 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11358 ( 556   ~;  70   |;4876   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3185 (3134 usr;3072 con; 0-8 aty)
%            Number of variables   : 7498 (7003   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : Probably requires at least 75 steps. 
%          : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Human23_1,s__Human) ).

fof(local_2,axiom,
    s__instance(s__Human23_2,s__Human) ).

fof(local_3,axiom,
    s__instance(s__Human23_3,s__Human) ).

fof(local_4,axiom,
    s__instance(s__Human23_4,s__Human) ).

fof(local_5,axiom,
    s__instance(s__Human23_5,s__Human) ).

fof(local_6,axiom,
    s__instance(s__Human23_6,s__Human) ).

fof(local_7,axiom,
    s__instance(s__Human23_7,s__Human) ).

fof(local_8,axiom,
    s__instance(s__Human23_8,s__Human) ).

fof(local_9,axiom,
    s__instance(s__Human23_9,s__Human) ).

fof(local_10,axiom,
    s__instance(s__Human23_10,s__Human) ).

fof(local_11,axiom,
    s__instance(s__Human23_11,s__Human) ).

fof(local_12,axiom,
    s__instance(s__Human23_12,s__Human) ).

fof(local_13,axiom,
    s__instance(s__Human23_13,s__Human) ).

fof(local_14,axiom,
    s__instance(s__Human23_14,s__Human) ).

fof(local_15,axiom,
    s__instance(s__Human23_15,s__Human) ).

fof(local_16,axiom,
    s__instance(s__Human23_16,s__Human) ).

fof(local_17,axiom,
    s__ancestor(s__Human23_1,s__Human23_2) ).

fof(local_18,axiom,
    s__ancestor(s__Human23_2,s__Human23_3) ).

fof(local_19,axiom,
    s__ancestor(s__Human23_3,s__Human23_4) ).

fof(local_20,axiom,
    s__ancestor(s__Human23_4,s__Human23_5) ).

fof(local_21,axiom,
    s__ancestor(s__Human23_5,s__Human23_6) ).

fof(local_22,axiom,
    s__ancestor(s__Human23_6,s__Human23_7) ).

fof(local_23,axiom,
    s__ancestor(s__Human23_7,s__Human23_8) ).

fof(local_24,axiom,
    s__ancestor(s__Human23_8,s__Human23_9) ).

fof(local_25,axiom,
    s__ancestor(s__Human23_9,s__Human23_10) ).

fof(local_26,axiom,
    s__ancestor(s__Human23_10,s__Human23_11) ).

fof(local_27,axiom,
    s__ancestor(s__Human23_11,s__Human23_12) ).

fof(local_28,axiom,
    s__ancestor(s__Human23_12,s__Human23_13) ).

fof(local_29,axiom,
    s__ancestor(s__Human23_13,s__Human23_14) ).

fof(local_30,axiom,
    s__ancestor(s__Human23_14,s__Human23_15) ).

fof(local_31,axiom,
    s__ancestor(s__Human23_14,s__Human23_16) ).

fof(prove_from_SUMO,conjecture,
    ( s__ancestor(s__Human23_1,s__Human23_15)
    & s__ancestor(s__Human23_1,s__Human23_16) ) ).

%------------------------------------------------------------------------------
