%------------------------------------------------------------------------------
% File     : CSR088+7 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Overlapping and meeting time
% Version  : Especial.
%            Theorem formulation : Existentially quantified, as a question.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG15

% Status   : ContradictoryAxioms
% Rating   : 0.61 v9.0.0, 0.56 v8.2.0, 0.64 v8.1.0, 0.61 v7.5.0, 0.69 v7.4.0, 0.14 v7.3.0
% Syntax   : Number of formulae    : 55590 (40664 unt;   0 def)
%            Number of atoms       : 150981 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99398 (4007   ~; 275   |;60337   &)
%                                         ( 249 <=>;34530  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33068 (32451 usr;32840 con; 0-8 aty)
%            Number of variables   : 56936 (49181   !;7755   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Time15_1,s__TimeInterval) ).

fof(local_2,axiom,
    s__instance(s__Time15_2,s__TimeInterval) ).

fof(local_3,axiom,
    s__meetsTemporally(s__Time15_1,s__Time15_2) ).

fof(prove_from_ALL,conjecture,
    ? [X__s__Time15_1,X__s__Time15_2] : ~ s__overlapsTemporally(X__s__Time15_1,X__s__Time15_2) ).

%------------------------------------------------------------------------------
