%------------------------------------------------------------------------------
% File     : CSR087+5 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Just one rule that cannot be satisfied
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG14

% Status   : ContradictoryAxioms
% Rating   : 0.88 v9.1.0, 0.85 v9.0.0, 0.86 v7.5.0, 0.84 v7.4.0, 0.29 v7.3.0
% Syntax   : Number of formulae    : 16752 (11416 unt;   0 def)
%            Number of atoms       : 38550 (1490 equ)
%            Maximal formula atoms :   23 (   2 avg)
%            Number of connectives : 22723 ( 925   ~; 115   |;10361   &)
%                                         ( 137 <=>;11185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9429 (8982 usr;9294 con; 0-8 aty)
%            Number of variables   : 13111 (11617   !;1494   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Atom14_1,s__Atom) ).

fof(local_2,axiom,
    s__instance(s__Nucleus14_1,s__AtomicNucleus) ).

fof(local_3,axiom,
    s__component(s__Nucleus14_1,s__Atom14_1) ).

fof(prove_from_SUMO_MILO,conjecture,
    ~ ? [V_NUCLEUS] :
        ( s__instance(V_NUCLEUS,s__AtomicNucleus)
        & s__component(V_NUCLEUS,s__Atom14_1)
        & V_NUCLEUS != s__Nucleus14_1 ) ).

%------------------------------------------------------------------------------
