%------------------------------------------------------------------------------
% File     : CSR087+4 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Just one rule that cannot be satisfied
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG14

% Status   : ContradictoryAxioms
% Rating   : 0.76 v9.0.0, 0.81 v7.5.0, 0.91 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 7221 (4494 unt;   0 def)
%            Number of atoms       : 18024 (1091 equ)
%            Maximal formula atoms :   22 (   2 avg)
%            Number of connectives : 11361 ( 558   ~;  70   |;4877   &)
%                                         ( 100 <=>;5756  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3171 (3120 usr;3058 con; 0-8 aty)
%            Number of variables   : 7499 (7003   !; 496   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Atom14_1,s__Atom) ).

fof(local_2,axiom,
    s__instance(s__Nucleus14_1,s__AtomicNucleus) ).

fof(local_3,axiom,
    s__component(s__Nucleus14_1,s__Atom14_1) ).

fof(prove_from_SUMO,conjecture,
    ~ ? [V_NUCLEUS] :
        ( s__instance(V_NUCLEUS,s__AtomicNucleus)
        & s__component(V_NUCLEUS,s__Atom14_1)
        & V_NUCLEUS != s__Nucleus14_1 ) ).

%------------------------------------------------------------------------------
