%------------------------------------------------------------------------------
% File     : CSR084+6 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Case elimination with multiple rules
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG10

% Status   : ContradictoryAxioms
% Rating   : 0.88 v9.1.0, 0.85 v9.0.0, 0.86 v7.5.0, 0.88 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 55594 (40663 unt;   0 def)
%            Number of atoms       : 151003 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99419 (4010   ~; 275   |;60349   &)
%                                         ( 249 <=>;34536  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33068 (32451 usr;32840 con; 0-8 aty)
%            Number of variables   : 56944 (49189   !;7755   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    ! [V_A] :
      ( s__instance(V_A,s__Object)
     => ( ( s__instance(V_A,s__Animal)
          & ~ ? [V_PART] :
                ( s__instance(V_PART,s__Object)
                & s__instance(V_PART,s__SpinalColumn)
                & s__part(V_PART,V_A) ) )
       => ~ s__instance(V_A,s__Vertebrate) ) ) ).

fof(local_2,axiom,
    ~ ? [V_SPINE] :
        ( s__instance(V_SPINE,s__Object)
        & s__instance(V_SPINE,s__SpinalColumn)
        & s__part(V_SPINE,s__BananaSlug10_1) ) ).

fof(local_3,axiom,
    s__partition_3(s__Animal,s__Vertebrate,s__Invertebrate) ).

fof(local_4,axiom,
    ! [V_SUPER,V_SUB1,V_SUB2] :
      ( ( s__instance(V_SUPER,s__Class)
        & s__instance(V_SUB1,s__Class)
        & s__instance(V_SUB2,s__Class) )
     => ( s__partition_3(V_SUPER,V_SUB1,V_SUB2)
       => s__partition_3(V_SUPER,V_SUB2,V_SUB1) ) ) ).

fof(local_5,axiom,
    ! [V_SUPER,V_SUB1,V_SUB2,V_INST] :
      ( ( s__instance(V_SUPER,s__Class)
        & s__instance(V_SUB1,s__Class)
        & s__instance(V_SUB2,s__Class) )
     => ( ( s__partition_3(V_SUPER,V_SUB1,V_SUB2)
          & s__instance(V_INST,V_SUPER)
          & ~ s__instance(V_INST,V_SUB1) )
       => s__instance(V_INST,V_SUB2) ) ) ).

fof(local_6,axiom,
    s__instance(s__BananaSlug10_1,s__Animal) ).

fof(local_7,axiom,
    ( s__instance(s__BodyPart10_1,s__BodyPart)
    & s__component(s__BodyPart10_1,s__BananaSlug10_1) ) ).

fof(prove_from_ALL,conjecture,
    s__instance(s__BananaSlug10_1,s__Invertebrate) ).

%------------------------------------------------------------------------------
