%------------------------------------------------------------------------------
% File     : CSR082+2 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Jane does reasoning and perception
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG8

% Status   : ContradictoryAxioms
% Rating   : 0.67 v9.1.0, 0.70 v9.0.0, 0.67 v8.1.0, 0.72 v7.5.0, 0.78 v7.4.0, 0.00 v7.3.0
% Syntax   : Number of formulae    : 37983 (32647 unt;   0 def)
%            Number of atoms       : 59780 (1489 equ)
%            Maximal formula atoms :   23 (   1 avg)
%            Number of connectives : 22720 ( 923   ~; 115   |;10360   &)
%                                         ( 137 <=>;11185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9428 (8981 usr;9293 con; 0-8 aty)
%            Number of variables   : 13112 (11617   !;1495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v3.4.1 - Bugfixes in CSR003+*.ax
%          : v3.4.2 - Bugfixes in CSR003+1.ax
%          : v3.5.0 - Bugfixes in CSR003+1.ax
%          : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%----Include cache axioms for SUMO+MILO
include('Axioms/CSR003+4.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Jane8_1,s__Human) ).

fof(prove_from_SUMO_MILO,conjecture,
    ? [V_ROLE1,V_ROLE2] :
      ( s__capability(s__Reasoning,V_ROLE1,s__Jane8_1)
      & s__capability(s__Perception,V_ROLE2,s__Jane8_1) ) ).

%------------------------------------------------------------------------------
