%------------------------------------------------------------------------------
% File     : CSR078+5 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Uses holdsDuring
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG4

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.1.0, 0.88 v9.0.0, 0.89 v8.1.0, 0.92 v7.5.0, 0.88 v7.4.0, 0.43 v7.3.0
% Syntax   : Number of formulae    : 16753 (11417 unt;   0 def)
%            Number of atoms       : 38554 (1489 equ)
%            Maximal formula atoms :   23 (   2 avg)
%            Number of connectives : 22726 ( 925   ~; 115   |;10362   &)
%                                         ( 137 <=>;11187  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  487 ( 486 usr;   0 prp; 1-8 aty)
%            Number of functors    : 9431 (8984 usr;9296 con; 0-8 aty)
%            Number of variables   : 13112 (11619   !;1493   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO_MILO
include('Axioms/CSR003+1.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Entity4_1,s__Human) ).

fof(local_2,axiom,
    s__instance(s__DoingSomething4_1,s__IntentionalProcess) ).

fof(local_3,axiom,
    s__agent(s__DoingSomething4_1,s__Entity4_1) ).

fof(local_4,axiom,
    ! [V_PROC,V_AGENT] :
      ( ( s__instance(V_PROC,s__Process)
        & s__instance(V_AGENT,s__Agent) )
     => ( ( s__agent(V_PROC,V_AGENT)
          & s__instance(V_PROC,s__IntentionalProcess) )
       => ( s__instance(V_AGENT,s__CognitiveAgent)
          & ~ s__holdsDuring(s__WhenFn(V_PROC),'s__attribute(V_AGENT,s__Dead)') ) ) ) ).

fof(prove_from_SUMO_MILO,conjecture,
    ~ s__holdsDuring(s__WhenFn(s__DoingSomething4_1),'s__attribute(s__Entity4_1,s__Dead)') ).

%------------------------------------------------------------------------------
