%------------------------------------------------------------------------------
% File     : CSR078+4 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Uses holdsDuring
% Version  : Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG4

% Status   : ContradictoryAxioms
% Rating   : 0.79 v9.0.0, 0.83 v8.1.0, 0.81 v7.5.0, 0.84 v7.4.0, 0.71 v7.3.0
% Syntax   : Number of formulae    : 7222 (4495 unt;   0 def)
%            Number of atoms       : 18028 (1090 equ)
%            Maximal formula atoms :   22 (   2 avg)
%            Number of connectives : 11364 ( 558   ~;  70   |;4878   &)
%                                         ( 100 <=>;5758  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3173 (3122 usr;3060 con; 0-8 aty)
%            Number of variables   : 7500 (7005   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__Entity4_1,s__Human) ).

fof(local_2,axiom,
    s__instance(s__DoingSomething4_1,s__IntentionalProcess) ).

fof(local_3,axiom,
    s__agent(s__DoingSomething4_1,s__Entity4_1) ).

fof(local_4,axiom,
    ! [V_PROC,V_AGENT] :
      ( ( s__instance(V_PROC,s__Process)
        & s__instance(V_AGENT,s__Agent) )
     => ( ( s__agent(V_PROC,V_AGENT)
          & s__instance(V_PROC,s__IntentionalProcess) )
       => ( s__instance(V_AGENT,s__CognitiveAgent)
          & ~ s__holdsDuring(s__WhenFn(V_PROC),'s__attribute(V_AGENT,s__Dead)') ) ) ) ).

fof(prove_from_SUMO,conjecture,
    ~ s__holdsDuring(s__WhenFn(s__DoingSomething4_1),'s__attribute(s__Entity4_1,s__Dead)') ).

%------------------------------------------------------------------------------
