%------------------------------------------------------------------------------
% File     : CSR076+7 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Relation subsumption
% Version  : Especial.
%            Theorem formulation : Existentially quantified, as a question.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG2

% Status   : ContradictoryAxioms
% Rating   : 0.94 v8.2.0, 0.89 v8.1.0, 0.92 v7.5.0, 0.91 v7.4.0, 0.57 v7.3.0
% Syntax   : Number of formulae    : 55594 (40667 unt;   0 def)
%            Number of atoms       : 150990 (14168 equ)
%            Maximal formula atoms :   29 (   2 avg)
%            Number of connectives : 99402 (4006   ~; 275   |;60340   &)
%                                         ( 249 <=>;34532  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   33 (   3 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of predicates  : 1201 (1200 usr;   0 prp; 1-8 aty)
%            Number of functors    : 33070 (32453 usr;32842 con; 0-8 aty)
%            Number of variables   : 56938 (49184   !;7754   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : 
% Bugfixes : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from all Sigma constituents
include('Axioms/CSR003+2.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TheKB2_1,s__ComputerProgram) ).

fof(local_2,axiom,
    s__instance(s__Inconsistent,s__Attribute) ).

fof(local_3,axiom,
    ! [V_ATTR1,V_ATTR2,V_X] :
      ( ( s__instance(V_ATTR1,s__Attribute)
        & s__instance(V_ATTR2,s__Attribute) )
     => ( ( s__contraryAttribute_2(V_ATTR1,V_ATTR2)
          & s__property(V_X,V_ATTR1)
          & s__property(V_X,V_ATTR2) )
       => s__property(s__TheKB2_1,s__Inconsistent) ) ) ).

fof(local_4,axiom,
    s__instance(s__Entity2_1,s__Organism) ).

fof(local_5,axiom,
    s__instance(s__Entity2_2,s__Organism) ).

fof(local_6,axiom,
    s__mother(s__Entity2_1,s__Entity2_2) ).

fof(local_7,axiom,
    s__father(s__Entity2_1,s__Entity2_2) ).

fof(prove_from_ALL,conjecture,
    ? [X__s__TheKB2_1] : s__property(X__s__TheKB2_1,s__Inconsistent) ).

%------------------------------------------------------------------------------
