%------------------------------------------------------------------------------
% File     : CSR076+1 : TPTP v9.2.0. Bugfixed v7.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Relation subsumption
% Version  : Especial > Augmented > Especial.
% English  :

% Refs     : [NP01]  Niles & Pease (2001), Towards A Standard Upper Ontology
%          : [Sie07] Siegel (2007), Email to G. Sutcliffe
% Source   : [Sie07]
% Names    : TQG2

% Status   : ContradictoryAxioms
% Rating   : 0.91 v9.1.0, 0.88 v9.0.0, 0.83 v8.1.0, 0.86 v7.5.0, 0.84 v7.4.0, 0.29 v7.3.0
% Syntax   : Number of formulae    : 14795 (12068 unt;   0 def)
%            Number of atoms       : 25601 (1090 equ)
%            Maximal formula atoms :   22 (   1 avg)
%            Number of connectives : 11362 ( 556   ~;  70   |;4878   &)
%                                         ( 100 <=>;5758  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   2 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :  290 ( 289 usr;   0 prp; 1-8 aty)
%            Number of functors    : 3173 (3122 usr;3060 con; 0-8 aty)
%            Number of variables   : 7501 (7006   !; 495   ?)
% SPC      : FOF_CAX_RFO_SEQ

% Comments : This version includes the cache axioms.
% Bugfixes : v4.0.0 - Bugfixes in CSR003 axiom files.
%          : v4.0.1 - Bugfixes in CSR003 axiom files.
%          : v4.1.0 - Bugfixes in CSR003 axiom files.
%          : v5.3.0 - Bugfixes in CSR003 axiom files.
%          : v5.4.0 - Bugfixes in CSR003 axiom files.
%          : v7.3.0 - Bugfixes in CSR003 axiom files.
%------------------------------------------------------------------------------
%----Include axioms from SUMO
include('Axioms/CSR003+0.ax').
%----Include cache axioms for SUMO
include('Axioms/CSR003+3.ax').
%------------------------------------------------------------------------------
fof(local_1,axiom,
    s__instance(s__TheKB2_1,s__ComputerProgram) ).

fof(local_2,axiom,
    s__instance(s__Inconsistent,s__Attribute) ).

fof(local_3,axiom,
    ! [V_ATTR1,V_ATTR2,V_X] :
      ( ( s__instance(V_ATTR1,s__Attribute)
        & s__instance(V_ATTR2,s__Attribute) )
     => ( ( s__contraryAttribute_2(V_ATTR1,V_ATTR2)
          & s__property(V_X,V_ATTR1)
          & s__property(V_X,V_ATTR2) )
       => s__property(s__TheKB2_1,s__Inconsistent) ) ) ).

fof(local_4,axiom,
    s__instance(s__Entity2_1,s__Organism) ).

fof(local_5,axiom,
    s__instance(s__Entity2_2,s__Organism) ).

fof(local_6,axiom,
    s__mother(s__Entity2_1,s__Entity2_2) ).

fof(local_7,axiom,
    s__father(s__Entity2_1,s__Entity2_2) ).

fof(prove_from_SUMO,conjecture,
    s__property(s__TheKB2_1,s__Inconsistent) ).

%------------------------------------------------------------------------------
