%--------------------------------------------------------------------------
% File     : CSR017+1 : TPTP v9.2.0. Bugfixed v3.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Not spinning at time 1
% Version  : [Mue04] axioms : Especial.
% English  :

% Refs     : [MS05]  Mueller & Sutcliffe (2005), Reasoning in the Event Cal
%          : [Mue04] Mueller (2004), A Tool for Satisfiability-based Common
%          : [MS02]  Miller & Shanahan (2002), Some Alternative Formulation
% Source   : [MS05]
% Names    :

% Status   : Theorem
% Rating   : 0.27 v9.1.0, 0.24 v9.0.0, 0.28 v8.2.0, 0.25 v8.1.0, 0.28 v7.5.0, 0.31 v7.4.0, 0.23 v7.3.0, 0.28 v7.2.0, 0.24 v7.1.0, 0.22 v7.0.0, 0.23 v6.4.0, 0.27 v6.3.0, 0.17 v6.2.0, 0.28 v6.1.0, 0.43 v6.0.0, 0.26 v5.5.0, 0.33 v5.4.0, 0.36 v5.3.0, 0.41 v5.2.0, 0.35 v5.1.0, 0.33 v5.0.0, 0.25 v4.1.0, 0.26 v4.0.1, 0.30 v4.0.0, 0.29 v3.7.0, 0.25 v3.5.0, 0.21 v3.4.0, 0.26 v3.3.0, 0.36 v3.1.0
% Syntax   : Number of formulae    :   48 (  22 unt;   0 def)
%            Number of atoms       :  138 (  43 equ)
%            Maximal formula atoms :   19 (   2 avg)
%            Number of connectives :  123 (  33   ~;  13   |;  51   &)
%                                         (  16 <=>;  10  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   4 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :   13 (  12 usr;   0 prp; 2-4 aty)
%            Number of functors    :   16 (  16 usr;  15 con; 0-2 aty)
%            Number of variables   :   73 (  64   !;   9   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%--------------------------------------------------------------------------
%----Include standard discrete event calculus axioms
include('Axioms/CSR001+0.ax').
%----Include supermarket trolley axioms
include('Axioms/CSR001+2.ax').
%--------------------------------------------------------------------------
fof(plus0_0,axiom,
    plus(n0,n0) = n0 ).

fof(plus0_1,axiom,
    plus(n0,n1) = n1 ).

fof(plus0_2,axiom,
    plus(n0,n2) = n2 ).

fof(plus0_3,axiom,
    plus(n0,n3) = n3 ).

fof(plus1_1,axiom,
    plus(n1,n1) = n2 ).

fof(plus1_2,axiom,
    plus(n1,n2) = n3 ).

fof(plus1_3,axiom,
    plus(n1,n3) = n4 ).

fof(plus2_2,axiom,
    plus(n2,n2) = n4 ).

fof(plus2_3,axiom,
    plus(n2,n3) = n5 ).

fof(plus3_3,axiom,
    plus(n3,n3) = n6 ).

fof(symmetry_of_plus,axiom,
    ! [X,Y] : plus(X,Y) = plus(Y,X) ).

fof(less_or_equal,axiom,
    ! [X,Y] :
      ( less_or_equal(X,Y)
    <=> ( less(X,Y)
        | X = Y ) ) ).

fof(less0,axiom,
    ~ ? [X] : less(X,n0) ).

fof(less1,axiom,
    ! [X] :
      ( less(X,n1)
    <=> less_or_equal(X,n0) ) ).

fof(less2,axiom,
    ! [X] :
      ( less(X,n2)
    <=> less_or_equal(X,n1) ) ).

fof(less3,axiom,
    ! [X] :
      ( less(X,n3)
    <=> less_or_equal(X,n2) ) ).

fof(less4,axiom,
    ! [X] :
      ( less(X,n4)
    <=> less_or_equal(X,n3) ) ).

fof(less5,axiom,
    ! [X] :
      ( less(X,n5)
    <=> less_or_equal(X,n4) ) ).

fof(less6,axiom,
    ! [X] :
      ( less(X,n6)
    <=> less_or_equal(X,n5) ) ).

fof(less7,axiom,
    ! [X] :
      ( less(X,n7)
    <=> less_or_equal(X,n6) ) ).

fof(less8,axiom,
    ! [X] :
      ( less(X,n8)
    <=> less_or_equal(X,n7) ) ).

fof(less9,axiom,
    ! [X] :
      ( less(X,n9)
    <=> less_or_equal(X,n8) ) ).

fof(less_property,axiom,
    ! [X,Y] :
      ( less(X,Y)
    <=> ( ~ less(Y,X)
        & Y != X ) ) ).

%----Initial conditions
fof(not_forwards_0,hypothesis,
    ~ holdsAt(forwards,n0) ).

fof(not_backwards_0,hypothesis,
    ~ holdsAt(backwards,n0) ).

fof(not_splinning_0,hypothesis,
    ~ holdsAt(spinning,n0) ).

fof(not_releasedAt,hypothesis,
    ! [Fluent,Time] : ~ releasedAt(Fluent,Time) ).

fof(not_spinning_1,conjecture,
    ~ holdsAt(spinning,n1) ).

%--------------------------------------------------------------------------
