%------------------------------------------------------------------------------
% File     : COM148+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Progress-T-app step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : Progress-T-Progress-T-app [Gre15]

% Status   : Theorem
% Rating   : 0.70 v9.1.0, 0.76 v9.0.0, 0.75 v8.2.0, 0.86 v8.1.0, 0.81 v7.5.0, 0.78 v7.4.0, 0.67 v7.3.0, 0.69 v7.1.0, 0.61 v7.0.0, 0.70 v6.4.0
% Syntax   : Number of formulae    :   59 (   6 unt;   0 def)
%            Number of atoms       :  300 ( 231 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  281 (  40   ~;  17   |; 125   &)
%                                         (   0 <=>;  99  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   8 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   18 (  18 usr;   5 con; 0-3 aty)
%            Number of variables   :  323 ( 252   !;  71   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Progress-T-app-IH1',axiom,
    ! [VT] :
      ( ( vtcheck(vempty,ve1,VT)
        & ~ visValue(ve1) )
     => ? [Veout] : vreduce(ve1) = vsomeExp(Veout) ) ).

fof('T-Progress-T-app-IH2',axiom,
    ! [VT] :
      ( ( vtcheck(vempty,ve2,VT)
        & ~ visValue(ve2) )
     => ? [Veout] : vreduce(ve2) = vsomeExp(Veout) ) ).

fof('T-Progress-T-app',conjecture,
    ! [VT] :
      ( ( vtcheck(vempty,vapp(ve1,ve2),VT)
        & ~ visValue(vapp(ve1,ve2)) )
     => ? [Veout] : vreduce(vapp(ve1,ve2)) = vsomeExp(Veout) ) ).

%------------------------------------------------------------------------------
