%------------------------------------------------------------------------------
% File     : COM146+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Preservation-T-var step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : Preservation-T-Preservation-T-var [Gre15]

% Status   : Theorem
% Rating   : 0.18 v9.1.0, 0.21 v9.0.0, 0.19 v8.2.0, 0.22 v8.1.0, 0.19 v7.5.0, 0.22 v7.4.0, 0.17 v7.3.0, 0.14 v7.1.0, 0.17 v7.0.0, 0.23 v6.4.0
% Syntax   : Number of formulae    :   59 (   6 unt;   0 def)
%            Number of atoms       :  300 ( 229 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  279 (  38   ~;  17   |; 125   &)
%                                         (   0 <=>;  99  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   9 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   16 (  16 usr;   3 con; 0-3 aty)
%            Number of variables   :  332 ( 264   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak-FreeVar',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-subst',axiom,
    ! [VT,VC,Vx,Ve,Ve2,VT2] :
      ( ( vtcheck(VC,Ve,VT)
        & vtcheck(vbind(Vx,VT,VC),Ve2,VT2) )
     => vtcheck(VC,vsubst(Vx,Ve,Ve2),VT2) ) ).

fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Preservation-T-var',conjecture,
    ! [Vx,VC,Veout,VT] :
      ( ( vreduce(vvar(Vx)) = vsomeExp(Veout)
        & vtcheck(VC,vvar(Vx),VT) )
     => vtcheck(VC,Veout,VT) ) ).

%------------------------------------------------------------------------------
