%------------------------------------------------------------------------------
% File     : COM145+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Preservation-T-app step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : Preservation-T-Preservation-T-app [Gre15]

% Status   : Theorem
% Rating   : 0.88 v9.1.0, 0.94 v9.0.0, 0.92 v7.5.0, 0.91 v7.4.0, 0.87 v7.3.0, 0.93 v7.1.0, 0.91 v7.0.0, 0.93 v6.4.0
% Syntax   : Number of formulae    :   61 (   6 unt;   0 def)
%            Number of atoms       :  306 ( 231 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  283 (  38   ~;  17   |; 127   &)
%                                         (   0 <=>; 101  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   8 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   18 (  18 usr;   5 con; 0-3 aty)
%            Number of variables   :  337 ( 269   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak-FreeVar',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-subst',axiom,
    ! [VT,VC,Vx,Ve,Ve2,VT2] :
      ( ( vtcheck(VC,Ve,VT)
        & vtcheck(vbind(Vx,VT,VC),Ve2,VT2) )
     => vtcheck(VC,vsubst(Vx,Ve,Ve2),VT2) ) ).

fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Preservation-T-app-IH1',axiom,
    ! [VC,Veout,VT] :
      ( ( vreduce(ve1) = vsomeExp(Veout)
        & vtcheck(VC,ve1,VT) )
     => vtcheck(VC,Veout,VT) ) ).

fof('T-Preservation-T-app-IH2',axiom,
    ! [VC,Veout,VT] :
      ( ( vreduce(ve2) = vsomeExp(Veout)
        & vtcheck(VC,ve2,VT) )
     => vtcheck(VC,Veout,VT) ) ).

fof('T-Preservation-T-app',conjecture,
    ! [VC,Veout,VT] :
      ( ( vreduce(vapp(ve1,ve2)) = vsomeExp(Veout)
        & vtcheck(VC,vapp(ve1,ve2),VT) )
     => vtcheck(VC,Veout,VT) ) ).

%------------------------------------------------------------------------------
