%------------------------------------------------------------------------------
% File     : COM141+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Weak-abs step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : Types-T-Weak-abs [Gre15]

% Status   : Theorem
% Rating   : 0.24 v9.0.0, 0.25 v8.2.0, 0.22 v7.5.0, 0.25 v7.4.0, 0.27 v7.3.0, 0.28 v7.1.0, 0.35 v7.0.0, 0.40 v6.4.0
% Syntax   : Number of formulae    :   58 (   6 unt;   0 def)
%            Number of atoms       :  299 ( 233 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  278 (  37   ~;  17   |; 126   &)
%                                         (   0 <=>;  98  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   9 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   17 (  17 usr;   4 con; 0-3 aty)
%            Number of variables   :  329 ( 261   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak-abs-IH',axiom,
    ! [Vx,VS,VC,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,veabs,VT) )
     => vtcheck(vbind(Vx,VS,VC),veabs,VT) ) ).

fof('T-Weak-abs-1',axiom,
    ! [Vx,VS,VC,Vy,VS1,VT] :
      ( ( Vx != Vy
        & vlookup(Vx,VC) = vnoType
        & vtcheck(VC,vabs(Vy,VS1,veabs),VT) )
     => vtcheck(vbind(Vx,VS,VC),vabs(Vy,VS1,veabs),VT) ) ).

fof('T-Weak-abs-2',axiom,
    ! [Vx,VS,VC,Vy,VS1,VT] :
      ( ( Vx = Vy
        & vlookup(Vx,VC) = vnoType
        & vtcheck(VC,vabs(Vy,VS1,veabs),VT) )
     => vtcheck(vbind(Vx,VS,VC),vabs(Vy,VS1,veabs),VT) ) ).

fof('T-Weak-abs',conjecture,
    ! [Vx,VS,VC,Vy,VS1,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,vabs(Vy,VS1,veabs),VT) )
     => vtcheck(vbind(Vx,VS,VC),vabs(Vy,VS1,veabs),VT) ) ).

%------------------------------------------------------------------------------
