%------------------------------------------------------------------------------
% File     : COM138+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Strong-var step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : Types-T-Strong-var [Gre15]

% Status   : Theorem
% Rating   : 0.52 v9.0.0, 0.53 v7.5.0, 0.59 v7.4.0, 0.47 v7.3.0, 0.52 v7.0.0, 0.57 v6.4.0
% Syntax   : Number of formulae    :   56 (   6 unt;   0 def)
%            Number of atoms       :  291 ( 228 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  272 (  37   ~;  17   |; 122   &)
%                                         (   0 <=>;  96  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   9 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   16 (  16 usr;   3 con; 0-3 aty)
%            Number of variables   :  317 ( 249   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong-var',conjecture,
    ! [Vx,VS,VC,Vy,VT] :
      ( ( ~ visFreeVar(Vx,vvar(Vy))
        & vtcheck(vbind(Vx,VS,VC),vvar(Vy),VT) )
     => vtcheck(VC,vvar(Vy),VT) ) ).

%------------------------------------------------------------------------------
