%------------------------------------------------------------------------------
% File     : COM129+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : Fresh-free-2 step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : SubstLemma-fresh-free-2 [Gre15]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.36 v9.0.0, 0.39 v8.2.0, 0.42 v8.1.0, 0.39 v7.5.0, 0.44 v7.4.0, 0.27 v7.3.0, 0.34 v7.1.0, 0.30 v7.0.0, 0.40 v6.4.0
% Syntax   : Number of formulae    :   66 (   7 unt;   0 def)
%            Number of atoms       :  317 ( 232 equ)
%            Maximal formula atoms :   33 (   4 avg)
%            Number of connectives :  296 (  45   ~;  17   |; 129   &)
%                                         (   0 <=>; 105  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   8 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    8 (   6 usr;   1 prp; 0-3 aty)
%            Number of functors    :   16 (  16 usr;   3 con; 0-3 aty)
%            Number of variables   :  355 ( 287   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
include('Axioms/COM001+1.ax').
%------------------------------------------------------------------------------
fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Weak-FreeVar',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-subst-abs-2-gen',axiom,
    ! [VT,VC,Vx,Ve,Vy,VS,Ve1,VT2] :
      ( ( Vx != Vy
        & ~ visFreeVar(Vy,Ve)
        & vtcheck(VC,Ve,VT)
        & vtcheck(vbind(Vx,VT,VC),vabs(Vy,VS,Ve1),VT2) )
     => vtcheck(VC,vsubst(Vx,Ve,vabs(Vy,VS,Ve1)),VT2) ) ).

fof('fresh-unequal-var-3',axiom,
    ! [Ve,Ve1,Vx,Vfresh] :
      ( Vfresh = vgensym(vapp(vapp(Ve,Ve1),vvar(Vx)))
     => Vx != Vfresh ) ).

fof('fresh-free-2',conjecture,
    ! [Ve,Vx,Vfresh,Ve1] :
      ( Vfresh = vgensym(vapp(vapp(Ve,Ve1),vvar(Vx)))
     => ~ visFreeVar(Vfresh,Ve1) ) ).

%------------------------------------------------------------------------------
