%------------------------------------------------------------------------------
% File     : COM126+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Weak-FreeVar-app step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : SubstLemmaAux-T-Weak-FreeVar-app [Gre15]

% Status   : Theorem
% Rating   : 0.64 v9.1.0, 0.61 v9.0.0, 0.67 v8.2.0, 0.69 v8.1.0, 0.64 v7.5.0, 0.72 v7.4.0, 0.60 v7.3.0, 0.62 v7.1.0, 0.57 v7.0.0, 0.63 v6.4.0
% Syntax   : Number of formulae    :   59 (   6 unt;   0 def)
%            Number of atoms       :  300 ( 228 equ)
%            Maximal formula atoms :   33 (   5 avg)
%            Number of connectives :  281 (  40   ~;  17   |; 125   &)
%                                         (   0 <=>;  99  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   9 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    7 (   5 usr;   1 prp; 0-3 aty)
%            Number of functors    :   18 (  18 usr;   5 con; 0-3 aty)
%            Number of variables   :  329 ( 261   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
%------------------------------------------------------------------------------
fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Weak-FreeVar-app-IH1',axiom,
    ! [Vx,VS,VC,VT] :
      ( ( ~ visFreeVar(Vx,ve1app)
        & vtcheck(VC,ve1app,VT) )
     => vtcheck(vbind(Vx,VS,VC),ve1app,VT) ) ).

fof('T-Weak-FreeVar-app-IH2',axiom,
    ! [Vx,VS,VC,VT] :
      ( ( ~ visFreeVar(Vx,ve2app)
        & vtcheck(VC,ve2app,VT) )
     => vtcheck(vbind(Vx,VS,VC),ve2app,VT) ) ).

fof('T-Weak-FreeVar-app',conjecture,
    ! [Vx,VS,VC,VT] :
      ( ( ~ visFreeVar(Vx,vapp(ve1app,ve2app))
        & vtcheck(VC,vapp(ve1app,ve2app),VT) )
     => vtcheck(vbind(Vx,VS,VC),vapp(ve1app,ve2app),VT) ) ).

%------------------------------------------------------------------------------
