%------------------------------------------------------------------------------
% File     : COM124+1 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Computing Theory
% Problem  : T-Weak-FreeVar-abs-2 step in progress/preservation proof
% Version  : Augmented > Especial.
% English  : This problem is a step within the proof of progress and 
%            preservation for the standard type system for the simply-typed 
%            lambda calculus.

% Refs     : [Pie02] Pierce (2002), Programming Languages
%          : [Gre15] Grewe (2015), Email to Geoff Sutcliffe
%          : [GE+15] Grewe et al. (2015), Type Systems for the Masses: Deri
% Source   : [Gre15]
% Names    : SubstLemmaAux-T-Weak-FreeVar-abs-2 [Gre15]

% Status   : Theorem
% Rating   : 0.76 v9.1.0, 0.82 v9.0.0, 0.81 v8.2.0, 0.86 v8.1.0, 0.81 v7.5.0, 0.78 v7.4.0, 0.73 v7.3.0, 0.83 v7.1.0, 0.74 v7.0.0, 0.87 v6.4.0
% Syntax   : Number of formulae    :   64 (   7 unt;   0 def)
%            Number of atoms       :  313 ( 230 equ)
%            Maximal formula atoms :   33 (   4 avg)
%            Number of connectives :  292 (  43   ~;  17   |; 129   &)
%                                         (   0 <=>; 103  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (   8 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :    8 (   6 usr;   1 prp; 0-3 aty)
%            Number of functors    :   17 (  17 usr;   4 con; 0-3 aty)
%            Number of variables   :  347 ( 279   !;  68   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Generated by Veritas: https://github.com/stg-tud/type-pragmatics
%          : This is an expanded version of the original, with most axioms
%            combined into COM001+0.ax.
%------------------------------------------------------------------------------
include('Axioms/COM001+0.ax').
include('Axioms/COM001+1.ax').
%------------------------------------------------------------------------------
fof('T-Weak',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( vlookup(Vx,VC) = vnoType
        & vtcheck(VC,Ve,VT) )
     => vtcheck(vbind(Vx,VS,VC),Ve,VT) ) ).

fof('T-Strong',axiom,
    ! [Vx,VS,VC,Ve,VT] :
      ( ( ~ visFreeVar(Vx,Ve)
        & vtcheck(vbind(Vx,VS,VC),Ve,VT) )
     => vtcheck(VC,Ve,VT) ) ).

fof('T-Weak-FreeVar-abs-1-gen',axiom,
    ! [Vx,VS,VC,Vy,VS1,Ve1,VT] :
      ( ( Vx != Vy
        & ~ visFreeVar(Vx,vabs(Vy,VS1,Ve1))
        & vtcheck(VC,vabs(Vy,VS1,Ve1),VT) )
     => vtcheck(vbind(Vx,VS,VC),vabs(Vy,VS1,Ve1),VT) ) ).

fof('T-Weak-FreeVar-abs-2',conjecture,
    ! [Vx,VS,VC,Vy,VS1,VT] :
      ( ( Vx = Vy
        & ~ visFreeVar(Vx,vabs(Vy,VS1,veabs))
        & vtcheck(VC,vabs(Vy,VS1,veabs),VT) )
     => vtcheck(vbind(Vx,VS,VC),vabs(Vy,VS1,veabs),VT) ) ).

%------------------------------------------------------------------------------
