%------------------------------------------------------------------------------
% File     : COM122_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 294
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_294 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  166 (  47 unt;  50 typ;   0 def)
%            Number of atoms       :  234 ( 107 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  159 (  41   ~;   4   |;  14   &)
%                                         (  31 <=>;  69  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   4 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   38 (  24   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :   31 (  31 usr;   6 con; 0-4 aty)
%            Number of variables   :  281 ( 239   !;  11   ?; 281   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (44)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : fun(list(A),fun(A,bool)) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osemiring__1__class_ONats,type,
    semiring_1_Nats: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: int > fun(atom,atom) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_b____,type,
    b: atom ).

%----Relevant facts (98)
tff(fact_0_div0,axiom,
    ! [X: atom] :
      ( member(atom,X,aa(list(atom),fun(atom,bool),set(atom),as))
     => ( divisor(X) != zero_zero(int) ) ) ).

tff(fact_1_a,axiom,
    member(atom,a,aa(list(atom),fun(atom,bool),set(atom),qEpres1907640072oeffs1(as))) ).

tff(fact_2_hd0,axiom,
    ! [X: atom] :
      ( member(atom,X,aa(list(atom),fun(atom,bool),set(atom),as))
     => ( aa(atom,int,hd_coeff,X) != zero_zero(int) ) ) ).

tff(fact_3__096b_A_058_Aset_Aas_096,axiom,
    member(atom,b,aa(list(atom),fun(atom,bool),set(atom),as)) ).

tff(fact_4__096a_A_061_Ahd__coeff1_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_Ab_096,axiom,
    a = aa(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,as))),b) ).

tff(fact_5__096EX_Ab_058set_Aas_O_Aa_A_061_Ahd__coeff1_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_Ab_096,axiom,
    ? [X3: atom] :
      ( member(atom,X3,aa(list(atom),fun(atom,bool),set(atom),as))
      & ( a = aa(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,as))),X3) ) ) ).

tff(fact_6_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_7_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_8_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z1) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_9_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( ring_1_of_int(A,Z1) = zero_zero(A) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_10__096_B_Bthesis_O_A_I_B_Bb_O_A_091_124_Ab_A_058_Aset_Aas_059_Aa_A_061_Ahd__coeff1_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_Ab_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [B1: atom] :
        ( member(atom,B1,aa(list(atom),fun(atom,bool),set(atom),as))
       => ( a != aa(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,as))),B1) ) ) ).

tff(fact_11_Z_Oanormal__decr,axiom,
    ! [A3: atom] :
      ( ( aa(atom,int,hd_coeff,A3) = zero_zero(int) )
     => ( ( divisor(A3) != zero_zero(int) )
       => ( divisor(decr_Z(A3)) != zero_zero(int) ) ) ) ).

tff(fact_12_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_13_Nats__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => member(A,zero_zero(A),semiring_1_Nats(A)) ) ).

tff(fact_14_iszero__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => iszero(A,zero_zero(A)) ) ).

tff(fact_15_iszero__def,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Z1: A] :
          ( iszero(A,Z1)
        <=> ( Z1 = zero_zero(A) ) ) ) ).

tff(fact_16_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z1) )
        <=> ( W = Z1 ) ) ) ).

tff(fact_17_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = map(B,A,G,Xs) )
    <=> ! [X4: B] :
          ( member(B,X4,aa(list(B),fun(B,bool),set(B),Xs))
         => ( aa(B,A,F,X4) = aa(B,A,G,X4) ) ) ) ).

tff(fact_18_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A3: A] : ( sgn_sgn(A,sgn_sgn(A,A3)) = sgn_sgn(A,A3) ) ) ).

tff(fact_19_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ( sgn_sgn(A,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_20_divisor__asubst,axiom,
    ! [A3: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A3)) = divisor(A3) ) ).

tff(fact_21_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys1: list(B)] :
      ( ? [Xs2: list(A)] : ( Ys1 = map(A,B,F,Xs2) )
    <=> ! [X4: B] :
          ( member(B,X4,aa(list(B),fun(B,bool),set(B),Ys1))
         => ? [Xa: A] : ( X4 = aa(A,B,F,Xa) ) ) ) ).

tff(fact_22_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xs: list(A)] :
      ( ! [X3: A] :
          ( member(A,X3,aa(list(A),fun(A,bool),set(A),Xs))
         => ( aa(A,B,F,X3) = aa(A,B,G,X3) ) )
     => ( map(A,B,F,Xs) = map(A,B,G,Xs) ) ) ).

tff(fact_23_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xs: list(A)] :
      ( ! [X3: A] :
          ( member(A,X3,aa(list(A),fun(A,bool),set(A),Xs))
         => ( aa(A,A,F,X3) = X3 ) )
     => ( map(A,A,F,Xs) = Xs ) ) ).

tff(fact_24_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys1: list(A),Xs: list(A)] :
      ( ( Xs = Ys1 )
     => ( ! [X3: A] :
            ( member(A,X3,aa(list(A),fun(A,bool),set(A),Ys1))
           => ( aa(A,B,F,X3) = aa(A,B,G,X3) ) )
       => ( map(A,B,F,Xs) = map(A,B,G,Ys1) ) ) ) ).

tff(fact_25_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> member(int,zero_zero(int),aa(list(int),fun(int,bool),set(int),Is)) ) ).

tff(fact_26__096a_A_061_ADvd_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_A0_A_0911_093_A_124_IEX_Ab_058set_Aas_O_Aa_A_061_Ahd__coeff1_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_Ab_J_096,axiom,
    ( ( a = dvd(zlcms(map(atom,int,hd_coeff,as)),zero_zero(int),cons(int,one_one(int),nil(int))) )
    | ? [X3: atom] :
        ( member(atom,X3,aa(list(atom),fun(atom,bool),set(atom),as))
        & ( a = aa(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,as))),X3) ) ) ) ).

tff(fact_27_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,sgn_sgn(A,Aa),zero_zero(A))
        <=> ord_less(A,Aa,zero_zero(A)) ) ) ).

tff(fact_28_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,Aa))
        <=> ord_less(A,zero_zero(A),Aa) ) ) ).

tff(fact_29_in__set__member,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( member(A,X1,aa(list(A),fun(A,bool),set(A),Xs))
    <=> pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xs),X1)) ) ).

tff(fact_30_ListMem__iff,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( listMem(A,X1,Xs)
    <=> member(A,X1,aa(list(A),fun(A,bool),set(A),Xs)) ) ).

tff(fact_31_List_Omember__def,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xs),X1))
    <=> member(A,X1,aa(list(A),fun(A,bool),set(A),Xs)) ) ).

tff(fact_32_list__ex1__iff,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xs)
    <=> ? [X4: A] :
          ( member(A,X4,aa(list(A),fun(A,bool),set(A),Xs))
          & pp(aa(A,bool,P1,X4))
          & ! [Y1: A] :
              ( ( member(A,Y1,aa(list(A),fun(A,bool),set(A),Xs))
                & pp(aa(A,bool,P1,Y1)) )
             => ( Y1 = X4 ) ) ) ) ).

tff(fact_33_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A5: A,List3: list(A),Aa: A] :
      ( ( cons(A,Aa,List3) = cons(A,A5,List4) )
    <=> ( ( Aa = A5 )
        & ( List3 = List4 ) ) ) ).

tff(fact_34_atom_Osimps_I2_J,axiom,
    ! [List4: list(int),Int22: int,Int12: int,List3: list(int),Int21: int,Int11: int] :
      ( ( dvd(Int11,Int21,List3) = dvd(Int12,Int22,List4) )
    <=> ( ( Int11 = Int12 )
        & ( Int21 = Int22 )
        & ( List3 = List4 ) ) ) ).

tff(fact_35_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X1,Xs)) = cons(A,aa(B,A,F,X1),map(B,A,F,Xs)) ) ).

tff(fact_36_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_37_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_38_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_39_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int,W: int] :
          ( ord_less(A,ring_1_of_int(A,W),ring_1_of_int(A,Z1))
        <=> ord_less(int,W,Z1) ) ) ).

tff(fact_40_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_41_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_42_zlcms_Osimps_I1_J,axiom,
    zlcms(nil(int)) = one_one(int) ).

tff(fact_43_hd__coeff1_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_44_asubst_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Ks1: list(int),I1: int] : ( asubst(I1,Ks1,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_45_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( ord_less(A,ring_1_of_int(A,Z1),zero_zero(A))
        <=> ord_less(int,Z1,zero_zero(int)) ) ) ).

tff(fact_46_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z1: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z1))
        <=> ord_less(int,zero_zero(int),Z1) ) ) ).

tff(fact_47_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_48_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_49_insert,axiom,
    ! [A: $tType,Y: A,Xs1: list(A),X2: A] :
      ( listMem(A,X2,Xs1)
     => listMem(A,X2,cons(A,Y,Xs1)) ) ).

tff(fact_50_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X2: A] :
          ( ( X2 != Y )
         => ( ~ ord_less(A,X2,Y)
           => ord_less(A,Y,X2) ) ) ) ).

tff(fact_51_member__rec_I1_J,axiom,
    ! [A: $tType,Y2: A,Xs: list(A),X1: A] :
      ( pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),cons(A,X1,Xs)),Y2))
    <=> ( ( X1 = Y2 )
        | pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),Xs),Y2)) ) ) ).

tff(fact_52_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ pp(aa(A,bool,aa(list(A),fun(A,bool),member1(A),nil(A)),Y)) ).

tff(fact_53_elem,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : listMem(A,X2,cons(A,X2,Xs1)) ).

tff(fact_54_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_55_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( cons(A,A4,List2) != nil(A) ) ).

tff(fact_56_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_57_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != cons(A,A4,List2) ) ).

tff(fact_58_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_59_sgn__1__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ( sgn_sgn(A,Aa) = one_one(A) )
        <=> ord_less(A,zero_zero(A),Aa) ) ) ).

tff(fact_60_sgn__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A3: A] :
          ( ord_less(A,zero_zero(A),A3)
         => ( sgn_sgn(A,A3) = one_one(A) ) ) ) ).

tff(fact_61_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_62_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_63_set__ConsD,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Y2: A] :
      ( member(A,Y2,aa(list(A),fun(A,bool),set(A),cons(A,X1,Xs)))
     => ( ( Y2 = X1 )
        | member(A,Y2,aa(list(A),fun(A,bool),set(A),Xs)) ) ) ).

tff(fact_64_not__iszero__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ~ iszero(A,one_one(A)) ) ).

tff(fact_65_Nats__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => member(A,one_one(A),semiring_1_Nats(A)) ) ).

tff(fact_66_divisor_Osimps_I2_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( divisor(dvd(D,I,Ks)) = D ) ).

tff(fact_67_member__set,axiom,
    ! [A: $tType] : ( member1(A) = set(A) ) ).

tff(fact_68_zlcms__pos,axiom,
    ! [Is: list(int)] :
      ( ! [X3: int] :
          ( member(int,X3,aa(list(int),fun(int,bool),set(int),Is))
         => ( X3 != zero_zero(int) ) )
     => ord_less(int,zero_zero(int),zlcms(Is)) ) ).

tff(fact_69_atom_Osize_I2_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( atom_size(dvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_70_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y2: A,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = cons(A,Y2,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xs = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y2 )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_71_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun(B,A),Xs: list(A),X1: A] :
      ( ( cons(A,X1,Xs) = map(B,A,F,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys1 = cons(B,Z,Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs = map(B,A,F,Zs) ) ) ) ).

tff(fact_72_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y != cons(A,A2,List1) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_75_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xs = cons(A,Y1,Ys) ) ) ).

tff(fact_76_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_77_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_78_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_79_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_80_gr__implies__not0,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_81_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_82_atom_Osize_I5_J,axiom,
    ! [List: list(int),Int2: int,Int1: int] : ( size_size(atom,dvd(Int1,Int2,List)) = zero_zero(nat) ) ).

tff(fact_83_insert__Nil,axiom,
    ! [A: $tType,X2: A] : ( insert(A,X2,nil(A)) = cons(A,X2,nil(A)) ) ).

tff(fact_84_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M: nat] :
      ( ( ord_less(nat,M,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
     => ( ( ( M = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
       => ( ( ord_less(nat,N1,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) ) ) ) ).

tff(fact_85_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_86_less__not__refl2,axiom,
    ! [M1: nat,N: nat] :
      ( ord_less(nat,N,M1)
     => ( M1 != N ) ) ).

tff(fact_87_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_88_linorder__neqE__nat,axiom,
    ! [Y: nat,X2: nat] :
      ( ( X2 != Y )
     => ( ~ ord_less(nat,X2,Y)
       => ord_less(nat,Y,X2) ) ) ).

tff(fact_89_nat__neq__iff,axiom,
    ! [N1: nat,M: nat] :
      ( ( M != N1 )
    <=> ( ord_less(nat,M,N1)
        | ord_less(nat,N1,M) ) ) ).

tff(fact_90_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_91_in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( member(A,X1,aa(list(A),fun(A,bool),set(A),Xs))
     => ( insert(A,X1,Xs) = Xs ) ) ).

tff(fact_92_List_Oinsert__def,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( ( member(A,X1,aa(list(A),fun(A,bool),set(A),Xs))
       => ( insert(A,X1,Xs) = Xs ) )
      & ( ~ member(A,X1,aa(list(A),fun(A,bool),set(A),Xs))
       => ( insert(A,X1,Xs) = cons(A,X1,Xs) ) ) ) ).

tff(fact_93_not__in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( ~ member(A,X1,aa(list(A),fun(A,bool),set(A),Xs))
     => ( insert(A,X1,Xs) = cons(A,X1,Xs) ) ) ).

tff(fact_94_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = cons(A,X1,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_95_hd__coeffs1__def,axiom,
    ! [Asa: list(atom)] : ( qEpres1907640072oeffs1(Asa) = cons(atom,dvd(zlcms(map(atom,int,hd_coeff,Asa)),zero_zero(int),cons(int,one_one(int),nil(int))),map(atom,atom,hd_coeff1(zlcms(map(atom,int,hd_coeff,Asa))),Asa)) ) ).

tff(fact_96_map__ident,axiom,
    ! [A: $tType,X: list(A)] : ( map(A,A,combi(A),X) = X ) ).

tff(fact_97_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

%----Arities (14)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (3)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(atom,int,hd_coeff,b) != zero_zero(int) ).

%------------------------------------------------------------------------------
