%------------------------------------------------------------------------------
% File     : COM120_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 289
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_289 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  167 (  68 unt;  52 typ;   0 def)
%            Number of atoms       :  200 ( 142 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  117 (  32   ~;   2   |;  13   &)
%                                         (  24 <=>;  46  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   48 (  30   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   38 (  38 usr;   5 con; 0-5 aty)
%            Number of variables   :  384 ( 335   !;  11   ?; 384   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:42
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) ) > fun(list(A),T) ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > fun(list(A),list(B)) ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otranspose,type,
    transpose: 
      !>[A: $tType] : ( list(list(A)) > list(list(A)) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odecr_092_060_094isub_062Z,type,
    decr_Z: atom > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: fun(atom,int) ).

tff(sy_c_PresArith_Ohd__coeff1,type,
    hd_coeff1: int > fun(atom,atom) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (98)
tff(fact_0_hd0,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => ( aa(atom,int,hd_coeff,X4) != zero_zero(int) ) ) ).

tff(fact_1_div0,axiom,
    ! [X4: atom] :
      ( member(atom,X4,set(atom,as))
     => ( divisor(X4) != zero_zero(int) ) ) ).

tff(fact_2_a,axiom,
    member(atom,a,set(atom,qEpres1907640072oeffs1(as))) ).

tff(fact_3__096a_A_061_ADvd_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_A0_A_0911_093_A_124_IEX_Ab_058set_Aas_O_Aa_A_061_Ahd__coeff1_A_Izlcms_A_Imap_Ahd__coeff_Aas_J_J_Ab_J_096,axiom,
    ( ( a = dvd(zlcms(aa(list(atom),list(int),map(atom,int,hd_coeff),as)),zero_zero(int),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),one_one(int)),nil(int))) )
    | ? [X2: atom] :
        ( member(atom,X2,set(atom,as))
        & ( a = aa(atom,atom,hd_coeff1(zlcms(aa(list(atom),list(int),map(atom,int,hd_coeff),as))),X2) ) ) ) ).

tff(fact_4_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_5_divisor_Osimps_I2_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( divisor(dvd(D,I,Ks)) = D ) ).

tff(fact_6_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_7_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z1) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_8_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int] :
          ( ( ring_1_of_int(A,Z1) = zero_zero(A) )
        <=> ( Z1 = zero_zero(int) ) ) ) ).

tff(fact_9_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_10_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_11_divisor__asubst,axiom,
    ! [A5: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A5)) = divisor(A5) ) ).

tff(fact_12_Z_Oanormal__decr,axiom,
    ! [A5: atom] :
      ( ( aa(atom,int,hd_coeff,A5) = zero_zero(int) )
     => ( ( divisor(A5) != zero_zero(int) )
       => ( divisor(decr_Z(A5)) != zero_zero(int) ) ) ) ).

tff(fact_13_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_14_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z1) )
        <=> ( W = Z1 ) ) ) ).

tff(fact_15_atom_Osimps_I2_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List1: list(int),Int23: int,Int13: int] :
      ( ( dvd(Int13,Int23,List1) = dvd(Int14,Int24,List4) )
    <=> ( ( Int13 = Int14 )
        & ( Int23 = Int24 )
        & ( List1 = List4 ) ) ) ).

tff(fact_16_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A5: A] : ( sgn_sgn(A,sgn_sgn(A,A5)) = sgn_sgn(A,A5) ) ) ).

tff(fact_17_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_18_zlcms_Osimps_I1_J,axiom,
    zlcms(nil(int)) = one_one(int) ).

tff(fact_19_hd__coeff1_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_20_asubst_Osimps_I5_J,axiom,
    ! [Va: int,V: int,Ks2: list(int),I2: int] : ( asubst(I2,Ks2,dvd(V,Va,nil(int))) = dvd(V,Va,nil(int)) ) ).

tff(fact_21_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_22_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ( sgn_sgn(A,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_23_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = aa(list(B),list(A),map(B,A,F),Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_24_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),nil(B)) = nil(A) ) ).

tff(fact_25_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_26_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xs) = aa(list(B),list(A),map(B,A,G),Xs) )
    <=> ! [X: B] :
          ( member(B,X,set(B,Xs))
         => ( aa(B,A,F,X) = aa(B,A,G,X) ) ) ) ).

tff(fact_27_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,X1)),aa(list(B),list(A),map(B,A,F),Xs)) ) ).

tff(fact_28_atom_Osize_I2_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( atom_size(dvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_29_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A4: A,List1: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List4) )
    <=> ( ( Aa = A4 )
        & ( List1 = List4 ) ) ) ).

tff(fact_30_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A3: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List3) ) ).

tff(fact_31_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> member(int,zero_zero(int),set(int,Is)) ) ).

tff(fact_32_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X3: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),Xs1) != Xs1 ) ).

tff(fact_33_not__Cons__self,axiom,
    ! [A: $tType,X3: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),Xs1) ) ).

tff(fact_34_set__ConsD,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Y2: A] :
      ( member(A,Y2,set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)))
     => ( ( Y2 = X1 )
        | member(A,Y2,set(A,Xs)) ) ) ).

tff(fact_35_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A3: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List3) != nil(A) ) ).

tff(fact_36_atom_Osize_I5_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( size_size(atom,dvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_37_map__cong,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Ys2: list(A),Xs: list(A)] :
      ( ( Xs = Ys2 )
     => ( ! [X2: A] :
            ( member(A,X2,set(A,Ys2))
           => ( aa(A,B,F,X2) = aa(A,B,G,X2) ) )
       => ( aa(list(A),list(B),map(A,B,F),Xs) = aa(list(A),list(B),map(A,B,G),Ys2) ) ) ) ).

tff(fact_38_map__idI,axiom,
    ! [A: $tType,F: fun(A,A),Xs: list(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,Xs))
         => ( aa(A,A,F,X2) = X2 ) )
     => ( aa(list(A),list(A),map(A,A,F),Xs) = Xs ) ) ).

tff(fact_39_map__ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B),Xs: list(A)] :
      ( ! [X2: A] :
          ( member(A,X2,set(A,Xs))
         => ( aa(A,B,F,X2) = aa(A,B,G,X2) ) )
     => ( aa(list(A),list(B),map(A,B,F),Xs) = aa(list(A),list(B),map(A,B,G),Xs) ) ) ).

tff(fact_40_ex__map__conv,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Ys2: list(B)] :
      ( ? [Xs2: list(A)] : ( Ys2 = aa(list(A),list(B),map(A,B,F),Xs2) )
    <=> ! [X: B] :
          ( member(B,X,set(B,Ys2))
         => ? [Xa: A] : ( X = aa(A,B,F,Xa) ) ) ) ).

tff(fact_41_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys2: list(A),Y2: A,Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys2) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xs = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( aa(B,A,F,Z) = Y2 )
          & ( aa(list(B),list(A),map(B,A,F),Zs) = Ys2 ) ) ) ).

tff(fact_42_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys2: list(B),F: fun(B,A),Xs: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = aa(list(B),list(A),map(B,A,F),Ys2) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys2 = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs = aa(list(B),list(A),map(B,A,F),Zs) ) ) ) ).

tff(fact_43_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y1: A,Ys1: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys1) ) ) ).

tff(fact_44_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List) ) ) ).

tff(fact_45_insert__Nil,axiom,
    ! [A: $tType,X3: A] : ( insert(A,X3,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),nil(A)) ) ).

tff(fact_46_in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( member(A,X1,set(A,Xs))
     => ( insert(A,X1,Xs) = Xs ) ) ).

tff(fact_47_not__in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( ~ member(A,X1,set(A,Xs))
     => ( insert(A,X1,Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) ) ) ).

tff(fact_48_List_Oinsert__def,axiom,
    ! [A: $tType,Xs: list(A),X1: A] :
      ( ( member(A,X1,set(A,Xs))
       => ( insert(A,X1,Xs) = Xs ) )
      & ( ~ member(A,X1,set(A,Xs))
       => ( insert(A,X1,Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) ) ) ) ).

tff(fact_49_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_50_hd__coeffs1__def,axiom,
    ! [Asa: list(atom)] : ( qEpres1907640072oeffs1(Asa) = aa(list(atom),list(atom),aa(atom,fun(list(atom),list(atom)),cons(atom),dvd(zlcms(aa(list(atom),list(int),map(atom,int,hd_coeff),Asa)),zero_zero(int),aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),one_one(int)),nil(int)))),aa(list(atom),list(atom),map(atom,atom,hd_coeff1(zlcms(aa(list(atom),list(int),map(atom,int,hd_coeff),Asa)))),Asa)) ) ).

tff(fact_51_I__hd__coeffs1,axiom,
    ! [Xs: list(int),Asa: list(atom)] :
      ( ! [X2: atom] :
          ( member(atom,X2,set(atom,Asa))
         => ( aa(atom,int,hd_coeff,X2) != zero_zero(int) ) )
     => ( ? [X: int] :
          ! [Xa: atom] :
            ( member(atom,Xa,set(atom,qEpres1907640072oeffs1(Asa)))
           => i_Z(Xa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X),Xs)) )
      <=> ? [X: int] :
          ! [Xa: atom] :
            ( member(atom,Xa,set(atom,Asa))
           => i_Z(Xa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X),Xs)) ) ) ) ).

tff(fact_52_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_53_map__ident,axiom,
    ! [A: $tType,X4: list(A)] : ( aa(list(A),list(A),map(A,A,combi(A)),X4) = X4 ) ).

tff(fact_54_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_55_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs1: list(A),X3: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),splice(A,Xs1,Ys))) ) ).

tff(fact_56_notin__set__sublistI,axiom,
    ! [A: $tType,I3: fun(nat,bool),Xs: list(A),X1: A] :
      ( ~ member(A,X1,set(A,Xs))
     => ~ member(A,X1,set(A,sublist(A,Xs,I3))) ) ).

tff(fact_57_in__set__sublistD,axiom,
    ! [A: $tType,I3: fun(nat,bool),Xs: list(A),X1: A] :
      ( member(A,X1,set(A,sublist(A,Xs,I3)))
     => member(A,X1,set(A,Xs)) ) ).

tff(fact_58_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_59_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_60_Z_Onot__dep__decr,axiom,
    ! [Xs: list(int),X1: int,Aa: atom] :
      ( ( aa(atom,int,hd_coeff,Aa) = zero_zero(int) )
     => ( i_Z(Aa,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X1),Xs))
      <=> i_Z(decr_Z(Aa),Xs) ) ) ).

tff(fact_61_hd__coeff_Osimps_I2_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( aa(atom,int,hd_coeff,dvd(D1,I1,Ks1)) = aa(list(int),int,list_case(int,int,zero_zero(int),combk(int,list(int))),Ks1) ) ).

tff(fact_62_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( concat(A,aa(list(B),list(list(A)),map(B,list(A),combc(B,list(A),list(A),combb(A,fun(list(A),list(A)),B,cons(A),F),nil(A))),Xs)) = aa(list(B),list(A),map(B,A,F),Xs) ) ).

tff(fact_63_atom_Osize_I6_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( size_size(atom,nDvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_64_atom_Osize_I4_J,axiom,
    ! [List2: list(int),Int3: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int3,List2)) = zero_zero(nat) ) ).

tff(fact_65_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int5: int,List1: list(int),Int4: int] :
      ( ( c_PresArith_Oatom_OLe(Int4,List1) = c_PresArith_Oatom_OLe(Int5,List4) )
    <=> ( ( Int4 = Int5 )
        & ( List1 = List4 ) ) ) ).

tff(fact_66_atom_Osimps_I3_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List1: list(int),Int23: int,Int13: int] :
      ( ( nDvd(Int13,Int23,List1) = nDvd(Int14,Int24,List4) )
    <=> ( ( Int13 = Int14 )
        & ( Int23 = Int24 )
        & ( List1 = List4 ) ) ) ).

tff(fact_67_Nil__eq__concat__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( nil(A) = concat(A,Xss) )
    <=> ! [X: list(A)] :
          ( member(list(A),X,set(list(A),Xss))
         => ( X = nil(A) ) ) ) ).

tff(fact_68_concat__eq__Nil__conv,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( ( concat(A,Xss) = nil(A) )
    <=> ! [X: list(A)] :
          ( member(list(A),X,set(list(A),Xss))
         => ( X = nil(A) ) ) ) ).

tff(fact_69_concat_Osimps_I1_J,axiom,
    ! [A: $tType] : ( concat(A,nil(list(A))) = nil(A) ) ).

tff(fact_70_divisor_Osimps_I1_J,axiom,
    ! [Ks: list(int),I: int] : ( divisor(c_PresArith_Oatom_OLe(I,Ks)) = one_one(int) ) ).

tff(fact_71_hd__coeff1_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_72_hd__coeff1_Osimps_I4_J,axiom,
    ! [V: int,Uu: int] : ( aa(atom,atom,hd_coeff1(Uu),c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_75_asubst_Osimps_I6_J,axiom,
    ! [Va: int,V: int,Ks2: list(int),I2: int] : ( asubst(I2,Ks2,nDvd(V,Va,nil(int))) = nDvd(V,Va,nil(int)) ) ).

tff(fact_76_asubst_Osimps_I4_J,axiom,
    ! [V: int,Ks2: list(int),I2: int] : ( asubst(I2,Ks2,c_PresArith_Oatom_OLe(V,nil(int))) = c_PresArith_Oatom_OLe(V,nil(int)) ) ).

tff(fact_77_atom_Osize_I1_J,axiom,
    ! [List2: list(int),Int3: int] : ( atom_size(c_PresArith_Oatom_OLe(Int3,List2)) = zero_zero(nat) ) ).

tff(fact_78_atom_Osize_I3_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int] : ( atom_size(nDvd(Int12,Int22,List2)) = zero_zero(nat) ) ).

tff(fact_79_hd__coeff_Osimps_I3_J,axiom,
    ! [Ks1: list(int),I1: int,D1: int] : ( aa(atom,int,hd_coeff,nDvd(D1,I1,Ks1)) = aa(list(int),int,list_case(int,int,zero_zero(int),combk(int,list(int))),Ks1) ) ).

tff(fact_80_hd__coeff_Osimps_I1_J,axiom,
    ! [Ks1: list(int),I1: int] : ( aa(atom,int,hd_coeff,c_PresArith_Oatom_OLe(I1,Ks1)) = aa(list(int),int,list_case(int,int,zero_zero(int),combk(int,list(int))),Ks1) ) ).

tff(fact_81_map__concat,axiom,
    ! [A: $tType,B: $tType,Xs: list(list(B)),F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),concat(B,Xs)) = concat(A,aa(list(list(B)),list(list(A)),map(list(B),list(A),map(B,A,F)),Xs)) ) ).

tff(fact_82_atom_Osimps_I6_J,axiom,
    ! [List3: list(int),Int21: int,Int11: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != nDvd(Int11,Int21,List3) ) ).

tff(fact_83_atom_Osimps_I7_J,axiom,
    ! [List2: list(int),Int3: int,List3: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List3) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_84_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I: int,D: int] : ( divisor(nDvd(D,I,Ks)) = D ) ).

tff(fact_85_atom_Osimps_I9_J,axiom,
    ! [List2: list(int),Int22: int,Int12: int,List3: list(int),Int21: int,Int11: int] : ( nDvd(Int11,Int21,List3) != dvd(Int12,Int22,List2) ) ).

tff(fact_86_atom_Osimps_I8_J,axiom,
    ! [List3: list(int),Int21: int,Int11: int,List2: list(int),Int22: int,Int12: int] : ( dvd(Int12,Int22,List2) != nDvd(Int11,Int21,List3) ) ).

tff(fact_87_atom_Osimps_I5_J,axiom,
    ! [List2: list(int),Int3: int,List3: list(int),Int21: int,Int11: int] : ( dvd(Int11,Int21,List3) != c_PresArith_Oatom_OLe(Int3,List2) ) ).

tff(fact_88_atom_Osimps_I4_J,axiom,
    ! [List3: list(int),Int21: int,Int11: int,List2: list(int),Int3: int] : ( c_PresArith_Oatom_OLe(Int3,List2) != dvd(Int11,Int21,List3) ) ).

tff(fact_89_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List1) ) ).

tff(fact_90_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_91_concat__map__maps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,list(A))] : ( concat(A,aa(list(B),list(list(A)),map(B,list(A),F),Xs)) = maps(B,A,F,Xs) ) ).

tff(fact_92_maps__def,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,list(A))] : ( maps(B,A,F,Xs) = concat(A,aa(list(B),list(list(A)),map(B,list(A),F),Xs)) ) ).

tff(fact_93_atom_Oexhaust,axiom,
    ! [Y: atom] :
      ( ! [Int: int,List: list(int)] : ( Y != c_PresArith_Oatom_OLe(Int,List) )
     => ( ! [Int1: int,Int2: int,List: list(int)] : ( Y != dvd(Int1,Int2,List) )
       => ~ ! [Int1: int,Int2: int,List: list(int)] : ( Y != nDvd(Int1,Int2,List) ) ) ) ).

tff(fact_94_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_95_transpose_Osimps_I3_J,axiom,
    ! [A: $tType,Xss: list(list(A)),Xs: list(A),X1: A] : ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)),Xss)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),concat(A,aa(list(list(A)),list(list(A)),map(list(A),list(A),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),combc(A,list(A),list(A),cons(A),nil(A))))),Xss)))),transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),Xs),concat(list(A),aa(list(list(A)),list(list(list(A))),map(list(A),list(list(A)),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),combc(list(A),list(list(A)),list(list(A)),cons(list(A)),nil(list(A)))))),Xss))))) ) ).

tff(fact_96_transpose__empty,axiom,
    ! [A: $tType,Xs: list(list(A))] :
      ( ( transpose(A,Xs) = nil(list(A)) )
    <=> ! [X: list(A)] :
          ( member(list(A),X,set(list(A),Xs))
         => ( X = nil(A) ) ) ) ).

tff(fact_97_transpose_Osimps_I1_J,axiom,
    ! [A: $tType] : ( transpose(A,nil(list(A))) = nil(list(A)) ) ).

%----Arities (10)
tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    divisor(a) != zero_zero(int) ).

%------------------------------------------------------------------------------
