%------------------------------------------------------------------------------
% File     : COM118_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 283
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_283 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  158 (  20 unt;  39 typ;   0 def)
%            Number of atoms       :  365 (  49 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  286 (  40   ~;   8   |;  13   &)
%                                         (  34 <=>; 191  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   27 (  18   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   18 (  18 usr;   4 con; 0-4 aty)
%            Number of variables   :  352 ( 322   !;   5   ?; 352   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:37
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ocomm__monoid,type,
    comm_monoid: 
      !>[A: $tType] : ( ( fun(A,fun(A,A)) * A ) > $o ) ).

tff(sy_c_Groups_Osemigroup,type,
    semigroup: 
      !>[A: $tType] : ( fun(A,fun(A,A)) > $o ) ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Oring__1__class_OInts,type,
    ring_1_Ints: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Nat_Osemiring__1__class_ONats,type,
    semiring_1_Nats: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Nat__Transfer_Otsub,type,
    nat_tsub: ( int * int ) > int ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_Oasubst,type,
    asubst: ( int * list(int) * atom ) > atom ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Ohd__coeffs1,type,
    qEpres1907640072oeffs1: list(atom) > list(atom) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

%----Relevant facts (99)
tff(fact_0_div0,axiom,
    ! [X1: atom] :
      ( member(atom,X1,set(atom,as))
     => ( divisor(X1) != zero_zero(int) ) ) ).

tff(fact_1_a,axiom,
    member(atom,a,set(atom,qEpres1907640072oeffs1(as))) ).

tff(fact_2_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_3_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_4_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z2) )
        <=> ( Z2 = zero_zero(int) ) ) ) ).

tff(fact_5_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int] :
          ( ( ring_1_of_int(A,Z2) = zero_zero(A) )
        <=> ( Z2 = zero_zero(int) ) ) ) ).

tff(fact_6_divisor__asubst,axiom,
    ! [A1: atom,Ks: list(int),I: int] : ( divisor(asubst(I,Ks,A1)) = divisor(A1) ) ).

tff(fact_7_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_8_Nats__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => member(A,zero_zero(A),semiring_1_Nats(A)) ) ).

tff(fact_9_iszero__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => iszero(A,zero_zero(A)) ) ).

tff(fact_10_iszero__def,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Z2: A] :
          ( iszero(A,Z2)
        <=> ( Z2 = zero_zero(A) ) ) ) ).

tff(fact_11_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z2: int,W1: int] :
          ( ( ring_1_of_int(A,W1) = ring_1_of_int(A,Z2) )
        <=> ( W1 = Z2 ) ) ) ).

tff(fact_12_hd0,axiom,
    ! [X1: atom] :
      ( member(atom,X1,set(atom,as))
     => ( hd_coeff(X1) != zero_zero(int) ) ) ).

tff(fact_13_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( sgn_sgn(A,sgn_sgn(A,A1)) = sgn_sgn(A,A1) ) ) ).

tff(fact_14_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ( sgn_sgn(A,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_15_semigroup_Oassoc,axiom,
    ! [A: $tType,C: A,B1: A,Aa: A,F: fun(A,fun(A,A))] :
      ( semigroup(A,F)
     => ( aa(A,A,aa(A,fun(A,A),F,aa(A,A,aa(A,fun(A,A),F,Aa),B1)),C) = aa(A,A,aa(A,fun(A,A),F,Aa),aa(A,A,aa(A,fun(A,A),F,B1),C)) ) ) ).

tff(fact_16_comm__monoid_Ocomm__neutral,axiom,
    ! [A: $tType,Aa: A,Z2: A,F: fun(A,fun(A,A))] :
      ( comm_monoid(A,F,Z2)
     => ( aa(A,A,aa(A,fun(A,A),F,Aa),Z2) = Aa ) ) ).

tff(fact_17_Ints__of__int,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z2: int] : member(A,ring_1_of_int(A,Z2),ring_1_Ints(A)) ) ).

tff(fact_18_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,Aa))
        <=> ord_less(A,zero_zero(A),Aa) ) ) ).

tff(fact_19_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,sgn_sgn(A,Aa),zero_zero(A))
        <=> ord_less(A,Aa,zero_zero(A)) ) ) ).

tff(fact_20_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less_eq(A,ring_1_of_int(A,Z2),zero_zero(A))
        <=> ord_less_eq(int,Z2,zero_zero(int)) ) ) ).

tff(fact_21_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less_eq(A,zero_zero(A),ring_1_of_int(A,Z2))
        <=> ord_less_eq(int,zero_zero(int),Z2) ) ) ).

tff(fact_22_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int,W1: int] :
          ( ord_less(A,ring_1_of_int(A,W1),ring_1_of_int(A,Z2))
        <=> ord_less(int,W1,Z2) ) ) ).

tff(fact_23_of__int__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int,W1: int] :
          ( ord_less_eq(A,ring_1_of_int(A,W1),ring_1_of_int(A,Z2))
        <=> ord_less_eq(int,W1,Z2) ) ) ).

tff(fact_24_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z2))
        <=> ord_less(int,zero_zero(int),Z2) ) ) ).

tff(fact_25_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z2: int] :
          ( ord_less(A,ring_1_of_int(A,Z2),zero_zero(A))
        <=> ord_less(int,Z2,zero_zero(int)) ) ) ).

tff(fact_26_less__int__def,axiom,
    ! [W1: int,Z2: int] :
      ( ord_less(int,Z2,W1)
    <=> ( ord_less_eq(int,Z2,W1)
        & ( Z2 != W1 ) ) ) ).

tff(fact_27_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_28_Ints__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => member(A,zero_zero(A),ring_1_Ints(A)) ) ).

tff(fact_29_Ints__cases,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Q: A] :
          ( member(A,Q,ring_1_Ints(A))
         => ~ ! [Z: int] : ( Q != ring_1_of_int(A,Z) ) ) ) ).

tff(fact_30_Ints__induct,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [P: fun(A,bool),Q: A] :
          ( member(A,Q,ring_1_Ints(A))
         => ( ! [Z: int] : pp(aa(A,bool,P,ring_1_of_int(A,Z)))
           => pp(aa(A,bool,P,Q)) ) ) ) ).

tff(fact_31_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ord_less_eq(A,X2,X2) ) ).

tff(fact_32_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_33_conj__le__cong,axiom,
    ! [P1: bool,P: bool,X3: int] :
      ( ( ord_less_eq(int,zero_zero(int),X3)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X3)
          & pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X3)
          & pp(P1) ) ) ) ).

tff(fact_34_imp__le__cong,axiom,
    ! [P1: bool,P: bool,X3: int] :
      ( ( ord_less_eq(int,zero_zero(int),X3)
       => ( pp(P)
        <=> pp(P1) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X3)
         => pp(P) )
      <=> ( ord_less_eq(int,zero_zero(int),X3)
         => pp(P1) ) ) ) ).

tff(fact_35_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less(A,Y1,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_36_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X4: A] : ord_less_eq(B,aa(A,B,F,X4),aa(A,B,G,X4)) ) ) ).

tff(fact_37_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
          | ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_38_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ( X3 = Y2 )
        <=> ( ord_less_eq(A,X3,Y2)
            & ord_less_eq(A,Y2,X3) ) ) ) ).

tff(fact_39_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
         => ord_less_eq(A,X2,Y1) ) ) ).

tff(fact_40_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_41_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X3: A,Y2: A] :
          ( ord_less_eq(A,Y2,X3)
         => ( ord_less_eq(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_42_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ( A1 = B2 )
         => ( ord_less_eq(A,B2,C2)
           => ord_less_eq(A,A1,C2) ) ) ) ).

tff(fact_43_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ord_less_eq(A,A1,B2)
         => ( ( B2 = C2 )
           => ord_less_eq(A,A1,C2) ) ) ) ).

tff(fact_44_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,X2)
           => ( X2 = Y1 ) ) ) ) ).

tff(fact_45_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less_eq(A,Y1,Z1)
           => ord_less_eq(A,X2,Z1) ) ) ) ).

tff(fact_46_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X3: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_47_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y1)
         => ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_48_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ ord_less(A,X2,X2) ) ).

tff(fact_49_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ( X3 != Y2 )
        <=> ( ord_less(A,X3,Y2)
            | ord_less(A,Y2,X3) ) ) ) ).

tff(fact_50_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
        <=> ( ord_less(A,Y2,X3)
            | ( X3 = Y2 ) ) ) ) ).

tff(fact_51_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
          | ( X2 = Y1 )
          | ord_less(A,Y1,X2) ) ) ).

tff(fact_52_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X3: A,Y2: A] :
          ( ~ ord_less(A,Y2,X3)
         => ( ~ ord_less(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_53_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_54_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( X2 != Y1 ) ) ) ).

tff(fact_55_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_56_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_57_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( X2 != Y1 ) ) ) ).

tff(fact_58_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( Y1 != X2 ) ) ) ).

tff(fact_59_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
         => ( ord_less(A,Y2,X3)
           => pp(P) ) ) ) ).

tff(fact_60_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A1: A] :
          ( ord_less(A,A1,B2)
         => ~ ord_less(A,B2,A1) ) ) ).

tff(fact_61_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ( A1 = B2 )
         => ( ord_less(A,B2,C2)
           => ord_less(A,A1,C2) ) ) ) ).

tff(fact_62_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ord_less(A,A1,B2)
         => ( ( B2 = C2 )
           => ord_less(A,A1,C2) ) ) ) ).

tff(fact_63_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( ord_less(A,Y1,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_64_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ~ ord_less(A,Y1,X2) ) ) ).

tff(fact_65_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less(A,X2,Y1)
         => ( ( X2 != Y1 )
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_66_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
        <=> ord_less_eq(A,Y2,X3) ) ) ).

tff(fact_67_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less_eq(A,X3,Y2)
        <=> ord_less(A,Y2,X3) ) ) ).

tff(fact_68_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
          | ord_less(A,Y1,X2) ) ) ).

tff(fact_69_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
        <=> ( ord_less_eq(A,X3,Y2)
            & ( X3 != Y2 ) ) ) ) ).

tff(fact_70_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X3: A] :
          ( ord_less(A,X3,Y2)
        <=> ( ord_less_eq(A,X3,Y2)
            & ~ ord_less_eq(A,Y2,X3) ) ) ) ).

tff(fact_71_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
        <=> ( ord_less(A,X3,Y2)
            | ( X3 = Y2 ) ) ) ) ).

tff(fact_72_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X2: A] :
          ( ~ ord_less(A,X2,Y1)
         => ord_less_eq(A,Y1,X2) ) ) ).

tff(fact_73_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y1: A] :
          ( ~ ord_less_eq(A,Y1,X2)
         => ord_less(A,X2,Y1) ) ) ).

tff(fact_74_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] :
      ( member(A,X3,A2)
    <=> pp(aa(A,bool,A2,X3)) ) ).

tff(fact_75_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ~ ord_less(A,X3,Y2)
         => ( ord_less_eq(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_76_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A1: A] :
          ( ( A1 != B2 )
         => ( ord_less_eq(A,A1,B2)
           => ord_less(A,A1,B2) ) ) ) ).

tff(fact_77_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ~ ord_less(A,X2,Y1) ) ) ).

tff(fact_78_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ord_less_eq(A,X2,Y1) ) ) ).

tff(fact_79_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X3: A] :
          ( ord_less_eq(A,X3,Y2)
         => ( ~ ord_less(A,X3,Y2)
          <=> ( X3 = Y2 ) ) ) ) ).

tff(fact_80_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ord_less_eq(A,X2,Y1)
         => ( ord_less(A,X2,Y1)
            | ( X2 = Y1 ) ) ) ) ).

tff(fact_81_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A1: A] :
          ( ord_less_eq(A,A1,B2)
         => ( ( A1 != B2 )
           => ord_less(A,A1,B2) ) ) ) ).

tff(fact_82_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( ord_less_eq(A,Y1,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_83_minf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ~ ord_less_eq(A,T,X1) ) ) ).

tff(fact_84_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ord_less_eq(A,T,X1) ) ) ).

tff(fact_85_minf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,X1,Z)
         => ord_less_eq(A,X1,T) ) ) ).

tff(fact_86_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [T: A] :
        ? [Z: A] :
        ! [X1: A] :
          ( ord_less(A,Z,X1)
         => ~ ord_less_eq(A,X1,T) ) ) ).

tff(fact_87_dense__le,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z1: A,Y1: A] :
          ( ! [X: A] :
              ( ord_less(A,X,Y1)
             => ord_less_eq(A,X,Z1) )
         => ord_less_eq(A,Y1,Z1) ) ) ).

tff(fact_88_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less(fun(A,B),F,G)
        <=> ( ord_less_eq(fun(A,B),F,G)
            & ~ ord_less_eq(fun(A,B),G,F) ) ) ) ).

tff(fact_89_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X: A] : ord_less_eq(B,aa(A,B,F,X),aa(A,B,G,X))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_90_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ord_less_eq(A,Aa,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_91_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z1: A,Y1: A,X2: A] :
          ( ord_less(A,X2,Y1)
         => ( ! [W: A] :
                ( ord_less(A,X2,W)
               => ( ord_less(A,W,Y1)
                 => ord_less_eq(A,W,Z1) ) )
           => ord_less_eq(A,Y1,Z1) ) ) ) ).

tff(fact_92_order__less__le__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less(A,Aa,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less(A,X,Y)
                 => ord_less(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,Aa),C) ) ) ) ) ).

tff(fact_93_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ord_less(A,Aa,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_94_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less_eq(A,Aa,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less(B,aa(A,B,F,Aa),C) ) ) ) ) ).

tff(fact_95_Nat__Transfer_Otransfer__nat__int__function__closures_I3_J,axiom,
    ! [Y1: int,X2: int] :
      ( ord_less_eq(int,zero_zero(int),X2)
     => ( ord_less_eq(int,zero_zero(int),Y1)
       => ord_less_eq(int,zero_zero(int),nat_tsub(X2,Y1)) ) ) ).

tff(fact_96_minf_I11_J,axiom,
    ! [C1: $tType,D: $tType] :
      ( ord(C1)
     => ! [F1: D] :
        ? [Z: C1] :
        ! [X1: C1] :
          ( ord_less(C1,X1,Z)
         => ( F1 = F1 ) ) ) ).

tff(fact_97_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ord_less(A,Aa,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_98_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F,B1) )
         => ( ord_less(B,B1,C)
           => ( ! [X: B,Y: B] :
                  ( ord_less(B,X,Y)
                 => ord_less(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

%----Arities (17)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    divisor(a) != zero_zero(int) ).

%------------------------------------------------------------------------------
