%------------------------------------------------------------------------------
% File     : COM117_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 274
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_274 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  194 (  55 unt;  64 typ;   0 def)
%            Number of atoms       :  245 ( 103 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  163 (  48   ~;  14   |;  14   &)
%                                         (  33 <=>;  54  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   21 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   40 (  28   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-5 aty)
%            Number of functors    :   48 (  48 usr;  10 con; 0-4 aty)
%            Number of variables   :  406 ( 354   !;   2   ?; 406   :)
%                                         (  50  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Logic_Ofm,type,
    fm: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (57)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oplus,type,
    cl_Groups_Oplus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMax,type,
    big_linorder_Max: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Finite__Set_Ofinite,type,
    finite_finite1: 
      !>[A: $tType] : ( fun(A,bool) > $o ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Logic_Oand,type,
    c_Logic_Oand: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OAnd,type,
    c_Logic_Ofm_OAnd: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OAtom,type,
    atom1: 
      !>[A: $tType] : ( A > fm(A) ) ).

tff(sy_c_Logic_Ofm_ONeg,type,
    neg: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OOr,type,
    c_Logic_Ofm_OOr: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Logic_Ofm_OTrueF,type,
    trueF: 
      !>[A: $tType] : fm(A) ).

tff(sy_c_Logic_Ointerpret,type,
    interpret: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(list(B),bool)) * fm(A) * list(B) ) > $o ) ).

tff(sy_c_Logic_Olist__conj,type,
    list_conj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Olist__disj,type,
    list_disj: 
      !>[A: $tType] : ( list(fm(A)) > fm(A) ) ).

tff(sy_c_Logic_Oneg,type,
    neg1: 
      !>[A: $tType] : ( fm(A) > fm(A) ) ).

tff(sy_c_Logic_Oor,type,
    c_Logic_Oor: 
      !>[A: $tType] : ( ( fm(A) * fm(A) ) > fm(A) ) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: fun(atom,fun(list(int),bool)) ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_PresArith_Oneg_092_060_094isub_062Z,type,
    neg_Z: atom > fm(atom) ).

tff(sy_c_PresArith_Ozlcms,type,
    zlcms: list(int) > int ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_QEpres__Mirabelle__iocckttzyp_Oqe__pres_092_060_094isub_0621,type,
    qEpres896714165pres_1: list(atom) > fm(atom) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_li____,type,
    li: int ).

tff(sy_v_lks____,type,
    lks: list(int) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_1__096_Ili_M_Alks_J_A_058_Aset_A_Ilbounds_Aas_J_096,axiom,
    pp(aa(fun(product_prod(int,list(int)),bool),bool,aa(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),member(product_prod(int,list(int))),aa(list(int),product_prod(int,list(int)),aa(int,fun(list(int),product_prod(int,list(int))),product_Pair(int,list(int)),li),lks)),set(product_prod(int,list(int)),lbounds(as)))) ).

tff(fact_2_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_3_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,X3),cons(int,x,xs))) ) ).

tff(fact_4__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa1),cons(int,X1,xs))) ) ).

tff(fact_5__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,Xa1),cons(int,X1,xs))) ) ).

tff(fact_6_Z_OI_092_060_094isub_062a__aneg,axiom,
    ! [Xsa: list(int),A2: atom] :
      ( interpret(atom,int,i_Z,neg_Z(A2),Xsa)
    <=> ~ pp(aa(list(int),bool,aa(atom,fun(list(int),bool),i_Z,A2),Xsa)) ) ).

tff(fact_7_lm,axiom,
    big_linorder_Max(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as)))))))) = aa(int,int,aa(int,fun(int,int),minus_minus(int),li),aa(list(int),int,aa(list(int),fun(list(int),int),iprod(int),lks),xs)) ).

tff(fact_8_Z_OI__list__conj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_conj(atom,Fs),Xsa)
    <=> ! [X2: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X2),set(fm(atom),Fs)))
         => interpret(atom,int,i_Z,X2,Xsa) ) ) ).

tff(fact_9_Z_OI__and,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oand(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OAnd(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_10_Z_OI__or,axiom,
    ! [Xsa: list(int),Phi_2: fm(atom),Phi_1: fm(atom)] :
      ( interpret(atom,int,i_Z,c_Logic_Oor(atom,Phi_1,Phi_2),Xsa)
    <=> interpret(atom,int,i_Z,c_Logic_Ofm_OOr(atom,Phi_1,Phi_2),Xsa) ) ).

tff(fact_11_Z_OI__neg,axiom,
    ! [Xsa: list(int),Phi: fm(atom)] :
      ( interpret(atom,int,i_Z,neg1(atom,Phi),Xsa)
    <=> interpret(atom,int,i_Z,neg(atom,Phi),Xsa) ) ).

tff(fact_12_Z_OI__list__disj,axiom,
    ! [Xsa: list(int),Fs: list(fm(atom))] :
      ( interpret(atom,int,i_Z,list_disj(atom,Fs),Xsa)
    <=> ? [X2: fm(atom)] :
          ( pp(aa(fun(fm(atom),bool),bool,aa(fm(atom),fun(fun(fm(atom),bool),bool),member(fm(atom)),X2),set(fm(atom),Fs)))
          & interpret(atom,int,i_Z,X2,Xsa) ) ) ).

tff(fact_13__096Max_A_123i_A_N_A_092_060langle_062ks_Mxs_092_060rangle_062_A_124ks_Ai_O_A_Ii_M_Aks_J_A_058_Aset_A_Ilbounds_Aas_J_125_058_A_123i_A_N_A_092_060langle_062ks_Mxs_092_060rangle_062_A_124ks_Ai_O_A_Ii_M_Aks_J_A_058_Aset_A_Ilbounds_Aas_J_125_096,axiom,
    pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),big_linorder_Max(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as))))))))),collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as))))))))) ).

tff(fact_14__096_B_Bthesis_O_A_I_B_Bli_Alks_O_A_091_124_A_Ili_M_Alks_J_A_058_Aset_A_Ilbounds_Aas_J_059_AMax_A_123i_A_N_A_092_060langle_062ks_Mxs_092_060rangle_062_A_124ks_Ai_O_A_Ii_M_Aks_J_A_058_Aset_A_Ilbounds_Aas_J_125_A_061_Ali_A_N_A_092_060langle_062lks_Mxs_092_060rangle_062_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Li: int,Lks: list(int)] :
        ( pp(aa(fun(product_prod(int,list(int)),bool),bool,aa(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),member(product_prod(int,list(int))),aa(list(int),product_prod(int,list(int)),aa(int,fun(list(int),product_prod(int,list(int))),product_Pair(int,list(int)),Li),Lks)),set(product_prod(int,list(int)),lbounds(as))))
       => ( big_linorder_Max(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as)))))))) != aa(int,int,aa(int,fun(int,int),minus_minus(int),Li),aa(list(int),int,aa(list(int),fun(list(int),int),iprod(int),Lks),xs)) ) ) ).

tff(fact_15_interpret_Osimps_I3_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),A2: A,H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,atom1(A,A2),Xsa)
    <=> pp(aa(list(B),bool,aa(A,fun(list(B),bool),H,A2),Xsa)) ) ).

tff(fact_16_interpret_Osimps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),H: fun(A,fun(list(B),bool))] : interpret(A,B,H,trueF(A),Xsa) ).

tff(fact_17_fm_Osimps_I4_J,axiom,
    ! [A: $tType,Fm4: fm(A),Fm3: fm(A)] :
      ( ( neg(A,Fm3) = neg(A,Fm4) )
    <=> ( Fm3 = Fm4 ) ) ).

tff(fact_18_fm_Osimps_I1_J,axiom,
    ! [A: $tType,A5: A,A2: A] :
      ( ( atom1(A,A2) = atom1(A,A5) )
    <=> ( A2 = A5 ) ) ).

tff(fact_19_fm_Osimps_I3_J,axiom,
    ! [A: $tType,Fm23: fm(A),Fm13: fm(A),Fm22: fm(A),Fm12: fm(A)] :
      ( ( c_Logic_Ofm_OOr(A,Fm12,Fm22) = c_Logic_Ofm_OOr(A,Fm13,Fm23) )
    <=> ( ( Fm12 = Fm13 )
        & ( Fm22 = Fm23 ) ) ) ).

tff(fact_20_fm_Osimps_I2_J,axiom,
    ! [A: $tType,Fm23: fm(A),Fm13: fm(A),Fm22: fm(A),Fm12: fm(A)] :
      ( ( c_Logic_Ofm_OAnd(A,Fm12,Fm22) = c_Logic_Ofm_OAnd(A,Fm13,Fm23) )
    <=> ( ( Fm12 = Fm13 )
        & ( Fm22 = Fm23 ) ) ) ).

tff(fact_21_interpret_Osimps_I6_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,neg(A,Phi),Xsa)
    <=> ~ interpret(A,B,H,Phi,Xsa) ) ).

tff(fact_22_interpret_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OOr(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        | interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_23_interpret_Osimps_I4_J,axiom,
    ! [A: $tType,B: $tType,Xsa: list(B),Phi_2: fm(A),Phi_1: fm(A),H: fun(A,fun(list(B),bool))] :
      ( interpret(A,B,H,c_Logic_Ofm_OAnd(A,Phi_1,Phi_2),Xsa)
    <=> ( interpret(A,B,H,Phi_1,Xsa)
        & interpret(A,B,H,Phi_2,Xsa) ) ) ).

tff(fact_24_fm_Osimps_I14_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( trueF(A) != neg(A,Fm) ) ).

tff(fact_25_fm_Osimps_I8_J,axiom,
    ! [A: $tType,A4: A] : ( trueF(A) != atom1(A,A4) ) ).

tff(fact_26_fm_Osimps_I12_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( trueF(A) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_27_fm_Osimps_I10_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( trueF(A) != c_Logic_Ofm_OAnd(A,Fm11,Fm21) ) ).

tff(fact_28_fm_Osimps_I15_J,axiom,
    ! [A: $tType,Fm: fm(A)] : ( neg(A,Fm) != trueF(A) ) ).

tff(fact_29_fm_Osimps_I9_J,axiom,
    ! [A: $tType,A4: A] : ( atom1(A,A4) != trueF(A) ) ).

tff(fact_30_fm_Osimps_I33_J,axiom,
    ! [A: $tType,A1: A,Fm: fm(A)] : ( neg(A,Fm) != atom1(A,A1) ) ).

tff(fact_31_fm_Osimps_I32_J,axiom,
    ! [A: $tType,Fm: fm(A),A1: A] : ( atom1(A,A1) != neg(A,Fm) ) ).

tff(fact_32_fm_Osimps_I43_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm: fm(A)] : ( neg(A,Fm) != c_Logic_Ofm_OOr(A,Fm1,Fm2) ) ).

tff(fact_33_fm_Osimps_I39_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm: fm(A)] : ( neg(A,Fm) != c_Logic_Ofm_OAnd(A,Fm1,Fm2) ) ).

tff(fact_34_fm_Osimps_I30_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),A1: A] : ( atom1(A,A1) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_35_fm_Osimps_I28_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),A1: A] : ( atom1(A,A1) != c_Logic_Ofm_OAnd(A,Fm11,Fm21) ) ).

tff(fact_36_fm_Osimps_I13_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != trueF(A) ) ).

tff(fact_37_fm_Osimps_I11_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm11,Fm21) != trueF(A) ) ).

tff(fact_38_fm_Osimps_I42_J,axiom,
    ! [A: $tType,Fm: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm1,Fm2) != neg(A,Fm) ) ).

tff(fact_39_fm_Osimps_I31_J,axiom,
    ! [A: $tType,A1: A,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != atom1(A,A1) ) ).

tff(fact_40_fm_Osimps_I38_J,axiom,
    ! [A: $tType,Fm: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm1,Fm2) != neg(A,Fm) ) ).

tff(fact_41_fm_Osimps_I29_J,axiom,
    ! [A: $tType,A1: A,Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm11,Fm21) != atom1(A,A1) ) ).

tff(fact_42_fm_Osimps_I37_J,axiom,
    ! [A: $tType,Fm2: fm(A),Fm1: fm(A),Fm21: fm(A),Fm11: fm(A)] : ( c_Logic_Ofm_OOr(A,Fm11,Fm21) != c_Logic_Ofm_OAnd(A,Fm1,Fm2) ) ).

tff(fact_43_fm_Osimps_I36_J,axiom,
    ! [A: $tType,Fm21: fm(A),Fm11: fm(A),Fm2: fm(A),Fm1: fm(A)] : ( c_Logic_Ofm_OAnd(A,Fm1,Fm2) != c_Logic_Ofm_OOr(A,Fm11,Fm21) ) ).

tff(fact_44__096finite_A_123i_A_N_A_092_060langle_062ks_Mxs_092_060rangle_062_A_124ks_Ai_O_A_Ii_M_Aks_J_A_058_Aset_A_Ilbounds_Aas_J_125_096,axiom,
    finite_finite1(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as)))))))) ).

tff(fact_45__096_123i_A_N_A_092_060langle_062ks_Mxs_092_060rangle_062_A_124ks_Ai_O_A_Ii_M_Aks_J_A_058_Aset_A_Ilbounds_Aas_J_125_A_126_061_A_123_125_096,axiom,
    collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as))))))) != bot_bot(fun(int,bool)) ).

tff(fact_46_iprod__Nil,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Ys: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),nil(A)),Ys) = zero_zero(A) ) ) ).

tff(fact_47_iprod__Nil2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),nil(A)) = zero_zero(A) ) ) ).

tff(fact_48_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),cons(A,X,Xs)),cons(A,Y,Ys)) = cons(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),X),Y),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)) ) ) ).

tff(fact_49_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),A1) = zero_zero(A) ) ) ).

tff(fact_50_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A5: A,List1: list(A),A2: A] :
      ( ( cons(A,A2,List1) = cons(A,A5,List2) )
    <=> ( ( A2 = A5 )
        & ( List1 = List2 ) ) ) ).

tff(fact_51_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A6: A,B6: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B6))) ) ).

tff(fact_52_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,B2: B,A2: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B5) )
    <=> ( ( A2 = A5 )
        & ( B2 = B5 ) ) ) ).

tff(fact_53_finite__set,axiom,
    ! [A: $tType,Xsa: list(A)] : finite_finite1(A,set(A,Xsa)) ).

tff(fact_54_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_55_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_56_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_57_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),nil(A)) = Xs ) ) ).

tff(fact_58_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_59_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B4: B,A4: A,B1: B,A1: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B1) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B4) )
     => ~ ( ( A1 = A4 )
         => ( B1 != B4 ) ) ) ).

tff(fact_60_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C2: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D) )
         => ( ( A2 = B2 )
          <=> ( C2 = D ) ) ) ) ).

tff(fact_61_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_62_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_63_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2) = zero_zero(A) )
        <=> ( A2 = B2 ) ) ) ).

tff(fact_64_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] :
          ( ( A2 = B2 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2) = zero_zero(A) ) ) ) ).

tff(fact_65_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_66_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,cons(A,Xa,Xsa))))
     => ( ( Y2 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_67_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A4: A] : ( cons(A,A4,List) != nil(A) ) ).

tff(fact_68_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A4: A] : ( nil(A) != cons(A,A4,List) ) ).

tff(fact_69_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),minus_minus(list(A)),Xs),Ys)),Zs) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs)),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

tff(fact_70_finite_OemptyI,axiom,
    ! [A: $tType] : finite_finite1(A,bot_bot(fun(A,bool))) ).

tff(fact_71_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( filter(A,P1,nil(A)) = nil(A) ) ).

tff(fact_72_set__filter,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] : ( set(A,filter(A,P1,Xsa)) = collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(fun(A,bool),bool)),fun(fun(A,bool),fun(A,bool)),combc(A,fun(A,bool),bool),member(A)),set(A,Xsa)))),P1)) ) ).

tff(fact_73_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = cons(A,Xa,filter(A,P1,Xsa)) ) )
      & ( ~ pp(aa(A,bool,P1,Xa))
       => ( filter(A,P1,cons(A,Xa,Xsa)) = filter(A,P1,Xsa) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A3))
    <=> pp(aa(A,bool,A3,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_finite__code,axiom,
    ! [A: $tType] :
      ( finite_finite(A)
     => ! [A3: fun(A,bool)] : finite_finite1(A,A3) ) ).

tff(fact_78_finite__Diff,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool)] :
      ( finite_finite1(A,A3)
     => finite_finite1(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A3),B3)) ) ).

tff(fact_79_finite__Collect__conjI,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ( finite_finite1(A,collect(A,P1))
        | finite_finite1(A,collect(A,Q1)) )
     => finite_finite1(A,collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),P1)),Q1))) ) ).

tff(fact_80_finite__Collect__disjI,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( finite_finite1(A,collect(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),P1)),Q1)))
    <=> ( finite_finite1(A,collect(A,P1))
        & finite_finite1(A,collect(A,Q1)) ) ) ).

tff(fact_81_filter__filter,axiom,
    ! [A: $tType,Xsa: list(A),Q1: fun(A,bool),P1: fun(A,bool)] : ( filter(A,P1,filter(A,Q1,Xsa)) = filter(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),Q1)),P1),Xsa) ) ).

tff(fact_82_zlcms0__iff,axiom,
    ! [Is: list(int)] :
      ( ( zlcms(Is) = zero_zero(int) )
    <=> pp(aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),zero_zero(int)),set(int,Is))) ) ).

tff(fact_83_finite,axiom,
    ! [A: $tType] :
      ( finite_finite(A)
     => ! [A3: fun(A,bool)] : finite_finite1(A,A3) ) ).

tff(fact_84_finite__Diff2,axiom,
    ! [A: $tType,A3: fun(A,bool),B3: fun(A,bool)] :
      ( finite_finite1(A,B3)
     => ( finite_finite1(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,bool),fun(fun(A,bool),fun(A,bool)),minus_minus(fun(A,bool)),A3),B3))
      <=> finite_finite1(A,A3) ) ) ).

tff(fact_85_filter__id__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = Xsa )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_86_finite__image__set,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),P1: fun(A,bool)] :
      ( finite_finite1(A,collect(A,P1))
     => finite_finite1(B,collect(B,aa(fun(B,fun(A,bool)),fun(B,bool),aa(fun(fun(A,bool),bool),fun(fun(B,fun(A,bool)),fun(B,bool)),combb(fun(A,bool),bool,B),fEx(A)),aa(fun(A,bool),fun(B,fun(A,bool)),aa(fun(B,fun(fun(A,bool),fun(A,bool))),fun(fun(A,bool),fun(B,fun(A,bool))),combc(B,fun(A,bool),fun(A,bool)),aa(fun(B,fun(A,fun(bool,bool))),fun(B,fun(fun(A,bool),fun(A,bool))),aa(fun(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool))),fun(fun(B,fun(A,fun(bool,bool))),fun(B,fun(fun(A,bool),fun(A,bool)))),combb(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),B),combs(A,bool,bool)),aa(fun(B,fun(A,bool)),fun(B,fun(A,fun(bool,bool))),aa(fun(fun(A,bool),fun(A,fun(bool,bool))),fun(fun(B,fun(A,bool)),fun(B,fun(A,fun(bool,bool)))),combb(fun(A,bool),fun(A,fun(bool,bool)),B),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj)),aa(fun(A,B),fun(B,fun(A,bool)),aa(fun(B,fun(fun(A,B),fun(A,bool))),fun(fun(A,B),fun(B,fun(A,bool))),combc(B,fun(A,B),fun(A,bool)),aa(fun(B,fun(B,bool)),fun(B,fun(fun(A,B),fun(A,bool))),aa(fun(fun(B,bool),fun(fun(A,B),fun(A,bool))),fun(fun(B,fun(B,bool)),fun(B,fun(fun(A,B),fun(A,bool)))),combb(fun(B,bool),fun(fun(A,B),fun(A,bool)),B),combb(B,bool,A)),fequal(B))),F)))),P1)))) ) ).

tff(fact_87_finite__Collect__bounded__ex,axiom,
    ! [B: $tType,A: $tType,Q1: fun(B,fun(A,bool)),P1: fun(A,bool)] :
      ( finite_finite1(A,collect(A,P1))
     => ( finite_finite1(B,collect(B,aa(fun(B,fun(A,bool)),fun(B,bool),aa(fun(fun(A,bool),bool),fun(fun(B,fun(A,bool)),fun(B,bool)),combb(fun(A,bool),bool,B),fEx(A)),aa(fun(B,fun(A,bool)),fun(B,fun(A,bool)),aa(fun(fun(A,bool),fun(A,bool)),fun(fun(B,fun(A,bool)),fun(B,fun(A,bool))),combb(fun(A,bool),fun(A,bool),B),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),P1))),Q1))))
      <=> ! [Y1: A] :
            ( pp(aa(A,bool,P1,Y1))
           => finite_finite1(B,collect(B,aa(A,fun(B,bool),aa(fun(B,fun(A,bool)),fun(A,fun(B,bool)),combc(B,A,bool),Q1),Y1))) ) ) ) ).

tff(fact_88_filter__empty__conv,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( ( filter(A,P1,Xsa) = nil(A) )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => ~ pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_89_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_90_iprod0__if__coeffs0,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Xsa: list(A),Cs: list(A)] :
          ( ! [X1: A] :
              ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Cs)))
             => ( X1 = zero_zero(A) ) )
         => ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Cs),Xsa) = zero_zero(A) ) ) ) ).

tff(fact_91_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C2,A2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_92_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_93_list__add__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Oplus(A)
        & zero(A) )
     => ! [Ys: list(A),Y: A,Xs: list(A),X: A] : ( plus_plus(list(A),cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,plus_plus(A,X,Y),plus_plus(list(A),Xs,Ys)) ) ) ).

tff(fact_94_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C1) = plus_plus(A,A1,plus_plus(A,B1,C1)) ) ) ).

tff(fact_95_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_96_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_97_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C1,A1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_98_iprod__left__add__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),plus_plus(list(A),Xs,Ys)),Zs) = plus_plus(A,aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Xs),Zs),aa(list(A),A,aa(list(A),fun(list(A),A),iprod(A),Ys),Zs)) ) ) ).

%----Arities (16)
tff(arity_fun___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oplus,axiom,
    cl_Groups_Oplus(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_HOL_Obool___Finite__Set_Ofinite,axiom,
    finite_finite(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

tff(arity_List_Olist___Groups_Oplus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Oplus(T_1) )
     => cl_Groups_Oplus(list(T_1)) ) ).

tff(arity_prod___Finite__Set_Ofinite,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( finite_finite(T_2)
        & finite_finite(T_1) )
     => finite_finite(product_prod(T_1,T_2)) ) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    interpret(atom,int,i_Z,qEpres896714165pres_1(as),xs) ).

%------------------------------------------------------------------------------
