%------------------------------------------------------------------------------
% File     : COM108_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 251
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_251 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  190 (  56 unt;  59 typ;   0 def)
%            Number of atoms       :  248 ( 113 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  170 (  53   ~;  23   |;  14   &)
%                                         (  24 <=>;  56  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   43 (  29   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-5 aty)
%            Number of functors    :   43 (  43 usr;  11 con; 0-5 aty)
%            Number of variables   :  349 ( 296   !;   7   ?; 349   :)
%                                         (  46  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (53)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Fact_Ofact__class_Ofact,type,
    fact_fact: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_GCD_OGcd__class_OLcm,type,
    gcd_Lcm: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OMin,type,
    min: int ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Int_Oring__1__class_OInts,type,
    ring_1_Ints: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olinorder__class_Osorted__list__of__set,type,
    linord467138063of_set: 
      !>[A: $tType] : ( fun(A,bool) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olists,type,
    lists: 
      !>[A: $tType] : ( fun(A,bool) > fun(list(A),bool) ) ).

tff(sy_c_List_Olistset,type,
    listset: 
      !>[A: $tType] : ( list(fun(A,bool)) > fun(list(A),bool) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Oset__Cons,type,
    set_Cons: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(list(A),bool) ) > fun(list(A),bool) ) ).

tff(sy_c_Nat_Osemiring__1__class_ONats,type,
    semiring_1_Nats: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Nat__Transfer_Ois__nat,type,
    nat_is_nat: int > $o ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > $o ) ).

tff(sy_c_PresArith_Ohd__coeff,type,
    hd_coeff: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (97)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),a),set(atom,as))) ).

tff(fact_1_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_2_of__int__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,one_one(int)) = one_one(A) ) ) ).

tff(fact_3__096is__dvd_Aa_096,axiom,
    atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),a) ).

tff(fact_4_Lcm__empty__int,axiom,
    gcd_Lcm(int,bot_bot(fun(int,bool))) = one_one(int) ).

tff(fact_5__096I_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    i_Z(a,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ).

tff(fact_6_hd,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),aa(fun(int,bool),bool,aa(int,fun(fun(int,bool),bool),member(int),hd_coeff(X3)),insert(int,one_one(int),insert(int,number_number_of(int,min),bot_bot(fun(int,bool))))))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int))))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),aa(int,bool,aa(int,fun(int,bool),fequal(int),hd_coeff(X3)),one_one(int))))),X3) ) ).

tff(fact_7_Nats__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),one_one(A)),semiring_1_Nats(A))) ) ).

tff(fact_8_fact__1__int,axiom,
    fact_fact(int,one_one(int)) = one_one(int) ).

tff(fact_9_not__iszero__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ~ iszero(A,one_one(A)) ) ).

tff(fact_10_Ints__1,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),one_one(A)),ring_1_Ints(A))) ) ).

tff(fact_11_Nat__Transfer_Otransfer__int__nat__function__closures_I6_J,axiom,
    nat_is_nat(one_one(int)) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y2: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Y2) )
        <=> ( Xa = Y2 ) ) ) ).

tff(fact_13__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X2: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),xs)) ) ).

tff(fact_14_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z1: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z1) )
        <=> ( W = Z1 ) ) ) ).

tff(fact_15_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),x),xs)) ) ).

tff(fact_16_of__int__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( ring_1_of_int(A,number_number_of(int,V)) = number_number_of(A,V) ) ) ).

tff(fact_17_of__int__m1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( ring_1_of_int(A,number_number_of(int,min)) = number_number_of(A,min) ) ) ).

tff(fact_18__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X2: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => i_Z(Xa1,aa(list(int),list(int),aa(int,fun(list(int),list(int)),cons(int),X2),xs)) ) ).

tff(fact_19_nonzero__number__of__Min,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ~ iszero(A,number_number_of(A,min)) ) ).

tff(fact_20_Ints__of__int,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z1: int] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),ring_1_of_int(A,Z1)),ring_1_Ints(A))) ) ).

tff(fact_21_Ints__number__of,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),number_number_of(A,W)),ring_1_Ints(A))) ) ).

tff(fact_22_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_23_number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [K: int] : ( number_number_of(A,K) = ring_1_of_int(A,K) ) ) ).

tff(fact_24_int__number__of__def,axiom,
    ! [W1: int] : ( number_number_of(int,W1) = ring_1_of_int(int,W1) ) ).

tff(fact_25_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W: int] :
          ( ( number_number_of(A,W) = Xa )
        <=> ( Xa = number_number_of(A,W) ) ) ) ).

tff(fact_26_List_Oset_Osimps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)) = insert(A,Xa,set(A,Xsa)) ) ).

tff(fact_27_singleton__conv2,axiom,
    ! [A: $tType,Aa: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),Aa)) = insert(A,Aa,bot_bot(fun(A,bool))) ) ).

tff(fact_28_singleton__conv,axiom,
    ! [A: $tType,Aa: A] : ( collect(A,combc(A,A,bool,fequal(A),Aa)) = insert(A,Aa,bot_bot(fun(A,bool))) ) ).

tff(fact_29_Ints__induct,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [P1: fun(A,bool),Q1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Q1),ring_1_Ints(A)))
         => ( ! [Z: int] : pp(aa(A,bool,P1,ring_1_of_int(A,Z)))
           => pp(aa(A,bool,P1,Q1)) ) ) ) ).

tff(fact_30_Ints__cases,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Q1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Q1),ring_1_Ints(A)))
         => ~ ! [Z: int] : ( Q1 != ring_1_of_int(A,Z) ) ) ) ).

tff(fact_31_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List2: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( Aa = A5 )
        & ( List2 = List3 ) ) ) ).

tff(fact_32_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] : ( insert(A,Xa,insert(A,Xa,A1)) = insert(A,Xa,A1) ) ).

tff(fact_33_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B1,A1)))
    <=> ( ( Aa = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_34_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B1,A1)))
     => ( ( Aa != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ) ).

tff(fact_35_emptyE,axiom,
    ! [A: $tType,Aa: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),bot_bot(fun(A,bool)))) ).

tff(fact_36_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_37_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_38_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X1: A] : ~ pp(aa(A,bool,P1,X1)) ) ).

tff(fact_39_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_40_insertCI,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),Aa: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B2))
       => ( Aa = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B1,B2))) ) ).

tff(fact_41_equals0D,axiom,
    ! [A: $tType,Aa: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1)) ) ).

tff(fact_42_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_43_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_44_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( insert(A,Aa,A1) = A1 ) ) ).

tff(fact_45_insertI2,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),Aa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,B1,B2))) ) ).

tff(fact_46_insert__eq__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),B1: A,A1: fun(A,bool),Aa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),B2))
       => ( ( insert(A,Aa,A1) = insert(A,B1,B2) )
        <=> ( ( ( Aa = B1 )
             => ( A1 = B2 ) )
            & ( ( Aa != B1 )
             => ? [C2: fun(A,bool)] :
                  ( ( A1 = insert(A,B1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C2))
                  & ( B2 = insert(A,Aa,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),C2)) ) ) ) ) ) ) ).

tff(fact_47_insert__ident,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B2))
       => ( ( insert(A,Xa,A1) = insert(A,Xa,B2) )
        <=> ( A1 = B2 ) ) ) ) ).

tff(fact_48_insert__code,axiom,
    ! [A: $tType,Xa: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A1),Xa))
    <=> ( ( Y2 = Xa )
        | pp(aa(A,bool,A1,Xa)) ) ) ).

tff(fact_49_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,Xa: A] : ( insert(A,Xa,insert(A,Y2,A1)) = insert(A,Y2,insert(A,Xa,A1)) ) ).

tff(fact_50_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),Aa: A] : ( insert(A,Aa,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),Aa))),P1)) ) ).

tff(fact_51_insert__compr,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: A] : ( insert(A,Aa,B2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),Aa)),combc(A,fun(A,bool),bool,member(A),B2))) ) ).

tff(fact_52_insertI1,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Aa),insert(A,Aa,B2))) ).

tff(fact_53_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_54_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_55_insert__compr__raw,axiom,
    ! [A: $tType,X3: A,Xa1: fun(A,bool)] : ( insert(A,X3,Xa1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X3)),combc(A,fun(A,bool),bool,member(A),Xa1))) ) ).

tff(fact_56_singleton__inject,axiom,
    ! [A: $tType,B1: A,Aa: A] :
      ( ( insert(A,Aa,bot_bot(fun(A,bool))) = insert(A,B1,bot_bot(fun(A,bool))) )
     => ( Aa = B1 ) ) ).

tff(fact_57_singletonE,axiom,
    ! [A: $tType,Aa: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,Aa,bot_bot(fun(A,bool)))))
     => ( B1 = Aa ) ) ).

tff(fact_58_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B1: A,Aa: A] :
      ( ( insert(A,Aa,insert(A,B1,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( Aa = C1 )
          & ( B1 = D ) )
        | ( ( Aa = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_59_singleton__iff,axiom,
    ! [A: $tType,Aa: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,Aa,bot_bot(fun(A,bool)))))
    <=> ( B1 = Aa ) ) ).

tff(fact_60_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( insert(A,Aa,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_61_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: A] : ( bot_bot(fun(A,bool)) != insert(A,Aa,A1) ) ).

tff(fact_62_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa))))
     => ( ( Y2 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y2),set(A,Xsa))) ) ) ).

tff(fact_63_Collect__conv__if,axiom,
    ! [A: $tType,Aa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),Aa)),P1)) = insert(A,Aa,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),Aa)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_64_Collect__conv__if2,axiom,
    ! [A: $tType,Aa: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),Aa)),P1)) = insert(A,Aa,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,Aa))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),Aa)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_65_the__elem__eq,axiom,
    ! [A: $tType,Xa: A] : ( the_elem(A,insert(A,Xa,bot_bot(fun(A,bool)))) = Xa ) ).

tff(fact_66_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [Xa: B] : ( aa(B,A,bot_bot(fun(B,A)),Xa) = bot_bot(A) ) ) ).

tff(fact_67_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X3: A] : ( aa(A,B,bot_bot(fun(A,B)),X3) = bot_bot(B) ) ) ).

tff(fact_68_List_Oset__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] : ( set(A,insert1(A,Xa,Xsa)) = insert(A,Xa,set(A,Xsa)) ) ).

tff(fact_69__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_70_List_Oset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( set(A,nil(A)) = bot_bot(fun(A,bool)) ) ).

tff(fact_71_set__empty2,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( bot_bot(fun(A,bool)) = set(A,Xsa) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_72_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_73_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
    <=> pp(aa(A,bool,A1,Xa)) ) ).

tff(fact_74_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_75_set__empty,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( set(A,Xsa) = bot_bot(fun(A,bool)) )
    <=> ( Xsa = nil(A) ) ) ).

tff(fact_76_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert1(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_77_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) ) ).

tff(fact_78_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) != nil(A) ) ).

tff(fact_79_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert1(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_80_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert1(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert1(A,Xa,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa) ) ) ) ).

tff(fact_81_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert1(A,Xa,Xsa) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa) ) ) ).

tff(fact_82_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xsa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) ) ) ).

tff(fact_83_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List) ) ) ).

tff(fact_84_listset_Osimps_I1_J,axiom,
    ! [A: $tType] : ( listset(A,nil(fun(A,bool))) = insert(list(A),nil(A),bot_bot(fun(list(A),bool))) ) ).

tff(fact_85_sorted__list__of__set__empty,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ( linord467138063of_set(A,bot_bot(fun(A,bool))) = nil(A) ) ) ).

tff(fact_86_listset_Osimps_I2_J,axiom,
    ! [A: $tType,As: list(fun(A,bool)),A1: fun(A,bool)] : ( listset(A,aa(list(fun(A,bool)),list(fun(A,bool)),aa(fun(A,bool),fun(list(fun(A,bool)),list(fun(A,bool))),cons(fun(A,bool)),A1),As)) = set_Cons(A,A1,listset(A,As)) ) ).

tff(fact_87_lists__empty,axiom,
    ! [A: $tType] : ( lists(A,bot_bot(fun(A,bool))) = insert(list(A),nil(A),bot_bot(fun(list(A),bool))) ) ).

tff(fact_88_Cons__in__lists__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),Xsa: list(A),Xa: A] :
      ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Xa),Xsa)),lists(A,A1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A1))
        & pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),Xsa),lists(A,A1))) ) ) ).

tff(fact_89_lists_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),nil(A)),lists(A,A1))) ).

tff(fact_90_in__lists__conv__set,axiom,
    ! [A: $tType,A1: fun(A,bool),Xsa: list(A)] :
      ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),Xsa),lists(A,A1)))
    <=> ! [X1: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Xsa)))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),A1)) ) ) ).

tff(fact_91_lists_Osimps,axiom,
    ! [A: $tType,A1: fun(A,bool),Aa: list(A)] :
      ( pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),Aa),lists(A,A1)))
    <=> ( ( Aa = nil(A) )
        | ? [A2: A,L: list(A)] :
            ( ( Aa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),L) )
            & pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
            & pp(aa(fun(list(A),bool),bool,aa(list(A),fun(fun(list(A),bool),bool),member(list(A)),L),lists(A,A1))) ) ) ) ).

tff(fact_92_set__Cons__sing__Nil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ( set_Cons(A,A1,insert(list(A),nil(A),bot_bot(fun(list(A),bool)))) = image(A,list(A),combc(A,list(A),list(A),cons(A),nil(A)),A1) ) ).

tff(fact_93_image__eqI,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),Xa: B,F: fun(B,A),B1: A] :
      ( ( B1 = aa(B,A,F,Xa) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),image(B,A,F,A1))) ) ) ).

tff(fact_94_empty__is__image,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( bot_bot(fun(A,bool)) = image(B,A,F,A1) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_95_image__empty,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( image(B,A,F,bot_bot(fun(B,bool))) = bot_bot(fun(A,bool)) ) ).

tff(fact_96_image__is__empty,axiom,
    ! [A: $tType,B: $tType,A1: fun(B,bool),F: fun(B,A)] :
      ( ( image(B,A,F,A1) = bot_bot(fun(A,bool)) )
    <=> ( A1 = bot_bot(fun(B,bool)) ) ) ).

%----Arities (10)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (23)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    hd_coeff(a) = one_one(int) ).

%------------------------------------------------------------------------------
