%------------------------------------------------------------------------------
% File     : COM107_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 249
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_249 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  196 (  68 unt;  71 typ;   0 def)
%            Number of atoms       :  219 ( 107 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  154 (  60   ~;  16   |;  16   &)
%                                         (  22 <=>;  40  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   19 (   2 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :   84 (  40   >;  44   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-6 aty)
%            Number of functors    :   56 (  56 usr;  11 con; 0-6 aty)
%            Number of variables   :  560 ( 493   !;   7   ?; 560   :)
%                                         (  60  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:31
%------------------------------------------------------------------------------
%----Should-be-implicit typings (12)
tff(ty_tc_Code__Evaluation_Oterm,type,
    code_term: $tType ).

tff(ty_tc_Code__Numeral_Ocode__numeral,type,
    code_code_numeral: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lazy__Sequence_Olazy__sequence,type,
    lazy_lazy_sequence: $tType > $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_Product__Type_Ounit,type,
    product_unit: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (59)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Olinorder__class_OMax,type,
    big_linorder_Max: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : fun(list(A),fun(list(A),A)) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_New__Random__Sequence_ORandom,type,
    new_Random_Random: 
      !>[A: $tType] : ( ( fun(code_code_numeral,fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(A,fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral)))) * code_code_numeral * code_code_numeral * product_prod(code_code_numeral,code_code_numeral) * code_code_numeral ) > lazy_lazy_sequence(A) ) ).

tff(sy_c_New__Random__Sequence_Oiter,type,
    new_Random_iter: 
      !>[A: $tType] : ( ( fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(A,fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral))) * code_code_numeral * product_prod(code_code_numeral,code_code_numeral) ) > lazy_lazy_sequence(A) ) ).

tff(sy_c_Partial__Function_Omk__less,type,
    partial_mk_less: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * A * A ) > $o ) ).

tff(sy_c_Predicate_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(B,bool)) * fun(A,B) * A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_ODvd,type,
    dvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_ONDvd,type,
    nDvd: ( int * int * list(int) ) > atom ).

tff(sy_c_PresArith_Oatom_Oatom__case,type,
    atom_case: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__rec,type,
    atom_rec: 
      !>[T: $tType] : ( ( fun(int,fun(list(int),T)) * fun(int,fun(int,fun(list(int),T))) * fun(int,fun(int,fun(list(int),T))) * atom ) > T ) ).

tff(sy_c_PresArith_Oatom_Oatom__size,type,
    atom_size: atom > nat ).

tff(sy_c_PresArith_Odivisor,type,
    divisor: atom > int ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Product__Type_OAbs__prod,type,
    product_Abs_prod: 
      !>[A: $tType,B: $tType] : ( fun(A,fun(B,bool)) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,product_prod(A,B))) ).

tff(sy_c_Product__Type_OPair__Rep,type,
    product_Pair_Rep: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > fun(A,fun(B,bool)) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Quickcheck__Exhaustive_Ocps__bind,type,
    quickcheck_cps_bind: 
      !>[A: $tType,B: $tType] : ( ( fun(fun(A,option(list(code_term))),option(list(code_term))) * fun(A,fun(fun(B,option(list(code_term))),option(list(code_term)))) * fun(B,option(list(code_term))) ) > option(list(code_term)) ) ).

tff(sy_c_Quickcheck__Exhaustive_Opos__bound__cps__single,type,
    quickc868703951single: 
      !>[A: $tType] : ( ( A * fun(A,option(product_prod(bool,list(code_term)))) * code_code_numeral ) > option(product_prod(bool,list(code_term))) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_li____,type,
    li: int ).

tff(sy_v_lks____,type,
    lks: list(int) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),a),set(atom,as))) ).

tff(fact_1_atom_Osimps_I10_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_case(A,F11,F21,F3,c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F11,Int3),List) ) ).

tff(fact_2_atom_Osimps_I12_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_case(A,F11,F21,F3,nDvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int11),Int21),List) ) ).

tff(fact_3_atom_Osimps_I11_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_case(A,F11,F21,F3,dvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F21,Int11),Int21),List) ) ).

tff(fact_4__096I_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    i_Z(a,cons(int,x,xs)) ).

tff(fact_5_pos__bound__cps__single__def,axiom,
    ! [A: $tType,V1: A,X3: fun(A,option(product_prod(bool,list(code_term)))),Xa1: code_code_numeral] : ( quickc868703951single(A,V1,X3,Xa1) = aa(A,option(product_prod(bool,list(code_term))),X3,V1) ) ).

tff(fact_6_mk__less__def,axiom,
    ! [A: $tType,R1: fun(A,fun(A,bool)),X3: A,Xa1: A] :
      ( partial_mk_less(A,R1,X3,Xa1)
    <=> ( pp(aa(A,bool,aa(A,fun(A,bool),R1,X3),Xa1))
        & ~ pp(aa(A,bool,aa(A,fun(A,bool),R1,Xa1),X3)) ) ) ).

tff(fact_7_cps__bind__def,axiom,
    ! [B: $tType,A: $tType,F: fun(B,fun(fun(A,option(list(code_term))),option(list(code_term)))),M: fun(fun(B,option(list(code_term))),option(list(code_term))),X3: fun(A,option(list(code_term)))] : ( quickcheck_cps_bind(B,A,M,F,X3) = aa(fun(B,option(list(code_term))),option(list(code_term)),M,aa(fun(A,option(list(code_term))),fun(B,option(list(code_term))),aa(fun(B,fun(fun(A,option(list(code_term))),option(list(code_term)))),fun(fun(A,option(list(code_term))),fun(B,option(list(code_term)))),combc(B,fun(A,option(list(code_term))),option(list(code_term))),F),X3)) ) ).

tff(fact_8_inv__imagep__def,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),R2: fun(B,fun(B,bool)),X3: A,Xa1: A] :
      ( inv_imagep(B,A,R2,F,X3,Xa1)
    <=> pp(aa(B,bool,aa(B,fun(B,bool),R2,aa(A,B,F,X3)),aa(A,B,F,Xa1))) ) ).

tff(fact_9_Pair__Rep__def,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,X3: A,Xa1: B] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),product_Pair_Rep(A,B,Aa,B1),X3),Xa1))
    <=> ( ( X3 = Aa )
        & ( Xa1 = B1 ) ) ) ).

tff(fact_10_New__Random__Sequence_ORandom__def,axiom,
    ! [A: $tType,G: fun(code_code_numeral,fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(A,fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral)))),X3: code_code_numeral,Xa1: code_code_numeral,Xb: product_prod(code_code_numeral,code_code_numeral),Xc: code_code_numeral] : ( new_Random_Random(A,G,X3,Xa1,Xb,Xc) = new_Random_iter(A,aa(code_code_numeral,fun(product_prod(code_code_numeral,code_code_numeral),product_prod(product_prod(A,fun(product_unit,code_term)),product_prod(code_code_numeral,code_code_numeral))),G,Xa1),X3,Xb) ) ).

tff(fact_11__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X1: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_12_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,cons(int,x,xs)) ) ).

tff(fact_13_atom_Osimps_I2_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int21: int,Int11: int] :
      ( ( dvd(Int11,Int21,List) = dvd(Int14,Int24,List4) )
    <=> ( ( Int11 = Int14 )
        & ( Int21 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_14_atom_Osimps_I1_J,axiom,
    ! [List4: list(int),Int5: int,List: list(int),Int3: int] :
      ( ( c_PresArith_Oatom_OLe(Int3,List) = c_PresArith_Oatom_OLe(Int5,List4) )
    <=> ( ( Int3 = Int5 )
        & ( List = List4 ) ) ) ).

tff(fact_15_atom_Osimps_I3_J,axiom,
    ! [List4: list(int),Int24: int,Int14: int,List: list(int),Int21: int,Int11: int] :
      ( ( nDvd(Int11,Int21,List) = nDvd(Int14,Int24,List4) )
    <=> ( ( Int11 = Int14 )
        & ( Int21 = Int24 )
        & ( List = List4 ) ) ) ).

tff(fact_16_in__inv__imagep,axiom,
    ! [A: $tType,B: $tType,Y3: B,Xa: B,F: fun(B,A),R2: fun(A,fun(A,bool))] :
      ( inv_imagep(A,B,R2,F,Xa,Y3)
    <=> pp(aa(A,bool,aa(A,fun(A,bool),R2,aa(B,A,F,Xa)),aa(B,A,F,Y3))) ) ).

tff(fact_17__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => i_Z(Xa1,cons(int,X1,xs)) ) ).

tff(fact_18_atom_Osimps_I4_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List1: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List1) != dvd(Int13,Int23,List3) ) ).

tff(fact_19_atom_Osimps_I6_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List1: list(int),Int: int] : ( c_PresArith_Oatom_OLe(Int,List1) != nDvd(Int13,Int23,List3) ) ).

tff(fact_20_atom_Osimps_I5_J,axiom,
    ! [List1: list(int),Int: int,List3: list(int),Int23: int,Int13: int] : ( dvd(Int13,Int23,List3) != c_PresArith_Oatom_OLe(Int,List1) ) ).

tff(fact_21_atom_Osimps_I7_J,axiom,
    ! [List1: list(int),Int: int,List3: list(int),Int23: int,Int13: int] : ( nDvd(Int13,Int23,List3) != c_PresArith_Oatom_OLe(Int,List1) ) ).

tff(fact_22_atom_Osimps_I8_J,axiom,
    ! [List3: list(int),Int23: int,Int13: int,List1: list(int),Int2: int,Int1: int] : ( dvd(Int1,Int2,List1) != nDvd(Int13,Int23,List3) ) ).

tff(fact_23_atom_Osimps_I9_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int,List3: list(int),Int23: int,Int13: int] : ( nDvd(Int13,Int23,List3) != dvd(Int1,Int2,List1) ) ).

tff(fact_24_list_Oinject,axiom,
    ! [A: $tType,List4: list(A),A6: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A6,List4) )
    <=> ( ( Aa = A6 )
        & ( List = List4 ) ) ) ).

tff(fact_25_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,cons(A,Xa,Xsa))))
     => ( ( Y3 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,Xsa))) ) ) ).

tff(fact_26__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_27_atom_Oexhaust,axiom,
    ! [Y: atom] :
      ( ! [Int4: int,List2: list(int)] : ( Y != c_PresArith_Oatom_OLe(Int4,List2) )
     => ( ! [Int12: int,Int22: int,List2: list(int)] : ( Y != dvd(Int12,Int22,List2) )
       => ~ ! [Int12: int,Int22: int,List2: list(int)] : ( Y != nDvd(Int12,Int22,List2) ) ) ) ).

tff(fact_28_atom_Orecs_I1_J,axiom,
    ! [A: $tType,List: list(int),Int3: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_rec(A,F11,F21,F3,c_PresArith_Oatom_OLe(Int3,List)) = aa(list(int),A,aa(int,fun(list(int),A),F11,Int3),List) ) ).

tff(fact_29_atom_Orecs_I3_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_rec(A,F11,F21,F3,nDvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F3,Int11),Int21),List) ) ).

tff(fact_30_atom_Orecs_I2_J,axiom,
    ! [A: $tType,List: list(int),Int21: int,Int11: int,F3: fun(int,fun(int,fun(list(int),A))),F21: fun(int,fun(int,fun(list(int),A))),F11: fun(int,fun(list(int),A))] : ( atom_rec(A,F11,F21,F3,dvd(Int11,Int21,List)) = aa(list(int),A,aa(int,fun(list(int),A),aa(int,fun(int,fun(list(int),A)),F21,Int11),Int21),List) ) ).

tff(fact_31_norm,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => ( divisor(X3) != zero_zero(int) ) ) ).

tff(fact_32_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_33_list_Osimps_I3_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( cons(A,A5,List3) != nil(A) ) ).

tff(fact_34_list_Osimps_I2_J,axiom,
    ! [A: $tType,List3: list(A),A5: A] : ( nil(A) != cons(A,A5,List3) ) ).

tff(fact_35_divisor_Osimps_I2_J,axiom,
    ! [Ks: list(int),I1: int,D2: int] : ( divisor(dvd(D2,I1,Ks)) = D2 ) ).

tff(fact_36_divisor_Osimps_I3_J,axiom,
    ! [Ks: list(int),I1: int,D2: int] : ( divisor(nDvd(D2,I1,Ks)) = D2 ) ).

tff(fact_37_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_38_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y1: A,Ys2: list(A)] : ( Xsa = cons(A,Y1,Ys2) ) ) ).

tff(fact_39_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List2: list(A)] : ( Y != cons(A,A2,List2) ) ) ).

tff(fact_40_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_41__096_Ili_M_Alks_J_A_058_Aset_A_Ilbounds_Aas_J_096,axiom,
    pp(aa(fun(product_prod(int,list(int)),bool),bool,aa(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),member(product_prod(int,list(int))),aa(list(int),product_prod(int,list(int)),aa(int,fun(list(int),product_prod(int,list(int))),product_Pair(int,list(int)),li),lks)),set(product_prod(int,list(int)),lbounds(as)))) ).

tff(fact_42_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_43_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A6: A,B1: B,Aa: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),B1) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A6),B6) )
    <=> ( ( Aa = A6 )
        & ( B1 = B6 ) ) ) ).

tff(fact_44_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_45_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,cons(A,X,Xs1),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs1,Ys1))) ) ).

tff(fact_46_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A5: A,B4: B,A1: A] :
      ( ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A1),B4) = aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A5),B5) )
     => ~ ( ( A1 = A5 )
         => ( B4 != B5 ) ) ) ).

tff(fact_47_pred__equals__eq2,axiom,
    ! [B: $tType,A: $tType,S: fun(product_prod(A,B),bool),R1: fun(product_prod(A,B),bool)] :
      ( ! [X2: A,Xa2: B] :
          ( pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Xa2)),R1))
        <=> pp(aa(fun(product_prod(A,B),bool),bool,aa(product_prod(A,B),fun(fun(product_prod(A,B),bool),bool),member(product_prod(A,B)),aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X2),Xa2)),S)) )
    <=> ( R1 = S ) ) ).

tff(fact_48_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_49_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_50_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_51_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_52_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ) ).

tff(fact_53_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ).

tff(fact_54_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,P1,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A4),B3))) ) ).

tff(fact_55_atom_Osize_I1_J,axiom,
    ! [List1: list(int),Int: int] : ( atom_size(c_PresArith_Oatom_OLe(Int,List1)) = zero_zero(nat) ) ).

tff(fact_56_atom_Osize_I3_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int] : ( atom_size(nDvd(Int1,Int2,List1)) = zero_zero(nat) ) ).

tff(fact_57_atom_Osize_I2_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int] : ( atom_size(dvd(Int1,Int2,List1)) = zero_zero(nat) ) ).

tff(fact_58_atom_Osize_I6_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int] : ( size_size(atom,nDvd(Int1,Int2,List1)) = zero_zero(nat) ) ).

tff(fact_59_atom_Osize_I4_J,axiom,
    ! [List1: list(int),Int: int] : ( size_size(atom,c_PresArith_Oatom_OLe(Int,List1)) = zero_zero(nat) ) ).

tff(fact_60_atom_Osize_I5_J,axiom,
    ! [List1: list(int),Int2: int,Int1: int] : ( size_size(atom,dvd(Int1,Int2,List1)) = zero_zero(nat) ) ).

tff(fact_61_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),B1)) = aa(C,A,aa(B,fun(C,A),F11,Aa),B1) ) ).

tff(fact_62_sublist__singleton,axiom,
    ! [A: $tType,Xa: A,A3: fun(nat,bool)] :
      ( ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(A,cons(A,Xa,nil(A)),A3) = cons(A,Xa,nil(A)) ) )
      & ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),zero_zero(nat)),A3))
       => ( sublist(A,cons(A,Xa,nil(A)),A3) = nil(A) ) ) ) ).

tff(fact_63_Pair__def,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A] : ( aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),B1) = product_Abs_prod(A,B,product_Pair_Rep(A,B,Aa,B1)) ) ).

tff(fact_64_sublist__nil,axiom,
    ! [A: $tType,A3: fun(nat,bool)] : ( sublist(A,nil(A),A3) = nil(A) ) ).

tff(fact_65_notin__set__sublistI,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I)))) ) ).

tff(fact_66_in__set__sublistD,axiom,
    ! [A: $tType,I: fun(nat,bool),Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,sublist(A,Xsa,I))))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa))) ) ).

tff(fact_67_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,nil(B)) = F11 ) ).

tff(fact_68_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F21,Aa),List) ) ).

tff(fact_69_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1)))),B2),aa(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1))),aa(C,fun(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1)))),product_Pair(C,product_prod(D,product_prod(E,F1))),C2),aa(product_prod(E,F1),product_prod(D,product_prod(E,F1)),aa(D,fun(product_prod(E,F1),product_prod(D,product_prod(E,F1))),product_Pair(D,product_prod(E,F1)),D1),aa(F1,product_prod(E,F1),aa(E,fun(F1,product_prod(E,F1)),product_Pair(E,F1),E1),F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,Xa)) ) ).

tff(fact_70_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),A2),aa(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),aa(B,fun(product_prod(C,product_prod(D,product_prod(E,F1))),product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1)))),B2),aa(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1))),aa(C,fun(product_prod(D,product_prod(E,F1)),product_prod(C,product_prod(D,product_prod(E,F1)))),product_Pair(C,product_prod(D,product_prod(E,F1))),C2),aa(product_prod(E,F1),product_prod(D,product_prod(E,F1)),aa(D,fun(product_prod(E,F1),product_prod(D,product_prod(E,F1))),product_Pair(D,product_prod(E,F1)),D1),aa(F1,product_prod(E,F1),aa(E,fun(F1,product_prod(E,F1)),product_Pair(E,F1),E1),F2))))) ) ).

tff(fact_71_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D,E1: E] : ( Y != aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1)))) ) ).

tff(fact_72_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,aa(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),aa(A,fun(product_prod(B,product_prod(C,product_prod(D,E))),product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))),product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E)))),A2),aa(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E))),aa(B,fun(product_prod(C,product_prod(D,E)),product_prod(B,product_prod(C,product_prod(D,E)))),product_Pair(B,product_prod(C,product_prod(D,E))),B2),aa(product_prod(D,E),product_prod(C,product_prod(D,E)),aa(C,fun(product_prod(D,E),product_prod(C,product_prod(D,E))),product_Pair(C,product_prod(D,E)),C2),aa(E,product_prod(D,E),aa(D,fun(E,product_prod(D,E)),product_Pair(D,E),D1),E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_73_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A2: A,B2: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,Xa)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A3))
    <=> pp(aa(A,bool,A3,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A2: A,B2: B,C2: C,D1: D] : ( Y != aa(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D))),aa(A,fun(product_prod(B,product_prod(C,D)),product_prod(A,product_prod(B,product_prod(C,D)))),product_Pair(A,product_prod(B,product_prod(C,D))),A2),aa(product_prod(C,D),product_prod(B,product_prod(C,D)),aa(B,fun(product_prod(C,D),product_prod(B,product_prod(C,D))),product_Pair(B,product_prod(C,D)),B2),aa(D,product_prod(C,D),aa(C,fun(D,product_prod(C,D)),product_Pair(C,D),C2),D1))) ) ).

tff(fact_78_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A2: A,B2: B,C2: C] : ( Y != aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B2),C2)) ) ).

tff(fact_79_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A2: A,B2: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,aa(product_prod(B,C),product_prod(A,product_prod(B,C)),aa(A,fun(product_prod(B,C),product_prod(A,product_prod(B,C))),product_Pair(A,product_prod(B,C)),A2),aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),B2),C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,Xa)) ) ).

tff(fact_80_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X1: A,Y2: B] : ( P2 != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),X1),Y2) ) ).

tff(fact_81_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A2: A,B2: B] : ( Y != aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),A2),B2) ) ).

tff(fact_82_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),B1)) = aa(C,A,aa(B,fun(C,A),C1,Aa),B1) ) ).

tff(fact_83_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_84_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,B1) = aa(product_prod(B,C),A,F,aa(C,product_prod(B,C),aa(B,fun(C,product_prod(B,C)),product_Pair(B,C),Aa),B1)) ) ).

tff(fact_85_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_86_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),B1)))
     => pp(product_curry(A,B,bool,F,Aa,B1)) ) ).

tff(fact_87_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),B1))) ) ).

tff(fact_88_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,Aa: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,Aa,B1))
     => pp(aa(product_prod(A,B),bool,F,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Aa),B1))) ) ).

tff(fact_89_list__ex1__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_ex1(A,P1,Xsa)
    <=> ? [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
          & pp(aa(A,bool,P1,X2))
          & ! [Y1: A] :
              ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y1),set(A,Xsa)))
                & pp(aa(A,bool,P1,Y1)) )
             => ( Y1 = X2 ) ) ) ) ).

tff(fact_90_curry__def,axiom,
    ! [C: $tType,A: $tType,B: $tType,X3: fun(product_prod(A,B),C),Xa1: A,Xb: B] : ( product_curry(A,B,C,X3,Xa1,Xb) = aa(product_prod(A,B),C,X3,aa(B,product_prod(A,B),aa(A,fun(B,product_prod(A,B)),product_Pair(A,B),Xa1),Xb)) ) ).

tff(fact_91_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,cons(A,Xa,Xsa))
    <=> ( ( pp(aa(A,bool,P1,Xa))
         => list_all(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),P1))),aa(A,fun(A,bool),fequal(A),Xa)),Xsa) )
        & ( ~ pp(aa(A,bool,P1,Xa))
         => list_ex1(A,P1,Xsa) ) ) ) ).

tff(fact_92_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xsa: list(A)] :
      ( ( Xsa != nil(A) )
     => ( ! [X1: A] : pp(aa(list(A),bool,P1,cons(A,X1,nil(A))))
       => ( ! [X1: A,Xs: list(A)] :
              ( ( Xs != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs))
               => pp(aa(list(A),bool,P1,cons(A,X1,Xs))) ) )
         => pp(aa(list(A),bool,P1,Xsa)) ) ) ) ).

tff(fact_93_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,P1: fun(A,bool)] :
      ( list_all(A,P1,cons(A,Xa,Xsa))
    <=> ( pp(aa(A,bool,P1,Xa))
        & list_all(A,P1,Xsa) ) ) ).

tff(fact_94_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_95_list__all__iff,axiom,
    ! [A: $tType,Xsa: list(A),P1: fun(A,bool)] :
      ( list_all(A,P1,Xsa)
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xsa)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_96_list__all__cong,axiom,
    ! [A: $tType,G: fun(A,bool),F: fun(A,bool),Ys: list(A),Xsa: list(A)] :
      ( ( Xsa = Ys )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,Ys)))
           => ( pp(aa(A,bool,F,X1))
            <=> pp(aa(A,bool,G,X1)) ) )
       => ( list_all(A,F,Xsa)
        <=> list_all(A,G,Ys) ) ) ) ).

tff(fact_97_lm,axiom,
    big_linorder_Max(int,collect(int,aa(fun(int,fun(list(int),bool)),fun(int,bool),aa(fun(fun(list(int),bool),bool),fun(fun(int,fun(list(int),bool)),fun(int,bool)),combb(fun(list(int),bool),bool,int),fEx(list(int))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool)),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),bool))),combb(fun(list(int),fun(int,bool)),fun(list(int),bool),int),aa(fun(fun(int,bool),bool),fun(fun(list(int),fun(int,bool)),fun(list(int),bool)),combb(fun(int,bool),bool,list(int)),fEx(int))),aa(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,bool)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),aa(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),aa(fun(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(int,fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))))),combb(fun(list(int),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,bool))),int),combs(list(int),fun(int,bool),fun(int,bool))),aa(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool)))),aa(fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),fun(fun(int,fun(list(int),fun(int,fun(bool,bool)))),fun(int,fun(list(int),fun(fun(int,bool),fun(int,bool))))),combb(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool))),int),aa(fun(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(bool,bool))),fun(list(int),fun(fun(int,bool),fun(int,bool)))),combb(fun(int,fun(bool,bool)),fun(fun(int,bool),fun(int,bool)),list(int)),combs(int,bool,bool))),aa(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool)))),aa(fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),fun(fun(int,fun(list(int),fun(int,bool))),fun(int,fun(list(int),fun(int,fun(bool,bool))))),combb(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool))),int),aa(fun(fun(int,bool),fun(int,fun(bool,bool))),fun(fun(list(int),fun(int,bool)),fun(list(int),fun(int,fun(bool,bool)))),combb(fun(int,bool),fun(int,fun(bool,bool)),list(int)),aa(fun(bool,fun(bool,bool)),fun(fun(int,bool),fun(int,fun(bool,bool))),combb(bool,fun(bool,bool),int),fconj))),aa(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(list(int),fun(int,int)),fun(int,fun(list(int),fun(int,bool)))),combc(int,fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),aa(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),aa(fun(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool)))),fun(fun(int,fun(fun(int,int),fun(int,bool))),fun(int,fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))))),combb(fun(fun(int,int),fun(int,bool)),fun(fun(list(int),fun(int,int)),fun(list(int),fun(int,bool))),int),combb(fun(int,int),fun(int,bool),list(int))),aa(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool))),aa(fun(fun(int,bool),fun(fun(int,int),fun(int,bool))),fun(fun(int,fun(int,bool)),fun(int,fun(fun(int,int),fun(int,bool)))),combb(fun(int,bool),fun(fun(int,int),fun(int,bool)),int),combb(int,bool,int)),fequal(int)))),aa(fun(list(int),int),fun(list(int),fun(int,int)),aa(fun(int,fun(int,int)),fun(fun(list(int),int),fun(list(int),fun(int,int))),combb(int,fun(int,int),list(int)),aa(fun(int,fun(int,int)),fun(int,fun(int,int)),combc(int,int,int),minus_minus(int))),aa(list(int),fun(list(int),int),aa(fun(list(int),fun(list(int),int)),fun(list(int),fun(list(int),int)),combc(list(int),list(int),int),iprod(int)),xs))))))),aa(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool)),aa(fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(product_prod(int,list(int)),bool),fun(list(int),fun(int,bool))),combc(list(int),fun(product_prod(int,list(int)),bool),fun(int,bool)),aa(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),aa(fun(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool))),fun(fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(list(int),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)))),combb(fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(product_prod(int,list(int)),bool),fun(int,bool)),list(int)),combc(int,fun(product_prod(int,list(int)),bool),bool)),aa(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),aa(fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),fun(fun(list(int),fun(int,product_prod(int,list(int)))),fun(list(int),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)))),combb(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool)),list(int)),aa(fun(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool)),fun(fun(int,product_prod(int,list(int))),fun(int,fun(fun(product_prod(int,list(int)),bool),bool))),combb(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),int),member(product_prod(int,list(int))))),aa(fun(int,fun(list(int),product_prod(int,list(int)))),fun(list(int),fun(int,product_prod(int,list(int)))),combc(int,list(int),product_prod(int,list(int))),product_Pair(int,list(int)))))),set(product_prod(int,list(int)),lbounds(as)))))))) = aa(int,int,aa(int,fun(int,int),minus_minus(int),li),aa(list(int),int,aa(list(int),fun(list(int),int),iprod(int),lks),xs)) ).

tff(fact_98_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),A1) = zero_zero(A) ) ) ).

%----Arities (4)
tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ozero,axiom,
    zero(code_code_numeral) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(atom_case(bool,combk(fun(list(int),bool),int,combk(bool,list(int),fFalse)),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),combk(fun(int,fun(list(int),bool)),int,combk(fun(list(int),bool),int,combk(bool,list(int),fTrue))),a)) ).

%------------------------------------------------------------------------------
