%------------------------------------------------------------------------------
% File     : COM103_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Number Theory
% Problem  : Quantifier elimination for Presburger arithmetic line 241
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Nip08] Nipkow (2008), Linear Quantifier Elimination
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : qe_241 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  180 (  52 unt;  50 typ;   0 def)
%            Number of atoms       :  281 (  75 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  192 (  41   ~;   8   |;  13   &)
%                                         (  16 <=>; 114  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   45 (  24   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   34 (  34 usr;  10 con; 0-6 aty)
%            Number of variables   :  507 ( 456   !;   6   ?; 507   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:02
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_PresArith_Oatom,type,
    atom: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (44)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ominus,type,
    cl_Groups_Ominus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_ListVector_Oiprod,type,
    iprod: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > A ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_PresArith_OI_092_060_094isub_062Z,type,
    i_Z: ( atom * list(int) ) > $o ).

tff(sy_c_PresArith_Oatom_OLe,type,
    c_PresArith_Oatom_OLe: ( int * list(int) ) > atom ).

tff(sy_c_PresArith_Olbounds,type,
    lbounds: list(atom) > list(product_prod(int,list(int))) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( fun(A,fun(B,T)) * product_prod(A,B) ) > T ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: atom ).

tff(sy_v_as,type,
    as: list(atom) ).

tff(sy_v_li____,type,
    li: int ).

tff(sy_v_lks____,type,
    lks: list(int) ).

tff(sy_v_x____,type,
    x: int ).

tff(sy_v_xs,type,
    xs: list(int) ).

%----Relevant facts (99)
tff(fact_0__096a_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),a),set(atom,as))) ).

tff(fact_1_x,axiom,
    ! [X3: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),X3),set(atom,as)))
     => i_Z(X3,cons(int,x,xs)) ) ).

tff(fact_2__096Le_Ali_A_I1_A_D_Alks_J_A_058_Aset_Aas_096,axiom,
    pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),c_PresArith_Oatom_OLe(li,cons(int,one_one(int),lks))),set(atom,as))) ).

tff(fact_3__096EX_Ax_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    ? [X: int] :
    ! [Xa1: atom] :
      ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
     => i_Z(Xa1,cons(int,X,xs)) ) ).

tff(fact_4__096I_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_096,axiom,
    i_Z(a,cons(int,x,xs)) ).

tff(fact_5_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X1: A] : ord_less_eq(A,X1,X1) ) ).

tff(fact_6_iprod__left__diff__distrib,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [Zs: list(A),Ys: list(A),Xs: list(A)] : ( iprod(A,minus_minus(list(A),Xs,Ys),Zs) = minus_minus(A,iprod(A,Xs,Zs),iprod(A,Ys,Zs)) ) ) ).

tff(fact_7_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D3: A,C1: A,B1: A,Aa: A] :
          ( ( minus_minus(A,Aa,B1) = minus_minus(A,C1,D3) )
         => ( ord_less_eq(A,Aa,B1)
          <=> ord_less_eq(A,C1,D3) ) ) ) ).

tff(fact_8_I_092_060_094isub_062Z_Osimps_I1_J,axiom,
    ! [Xsa: list(int),Ksa: list(int),Ia: int] :
      ( i_Z(c_PresArith_Oatom_OLe(Ia,Ksa),Xsa)
    <=> ord_less_eq(int,Ia,iprod(int,Ksa,Xsa)) ) ).

tff(fact_9_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( cl_Groups_Ominus(B)
     => ! [B3: fun(A,B),A2: fun(A,B),X3: A] : ( aa(A,B,minus_minus(fun(A,B),A2,B3),X3) = minus_minus(B,aa(A,B,A2,X3),aa(A,B,B3,X3)) ) ) ).

tff(fact_10_minus__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( cl_Groups_Ominus(A)
     => ! [Xa: B,B3: fun(B,A),A2: fun(B,A)] : ( aa(B,A,minus_minus(fun(B,A),A2,B3),Xa) = minus_minus(A,aa(B,A,A2,Xa),aa(B,A,B3,Xa)) ) ) ).

tff(fact_11_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D3: A,C1: A,B1: A,Aa: A] :
          ( ( minus_minus(A,Aa,B1) = minus_minus(A,C1,D3) )
         => ( ( Aa = B1 )
          <=> ( C1 = D3 ) ) ) ) ).

tff(fact_12_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_13_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
          | ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_14_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y3: A,Xa: A] :
          ( ( Xa = Y3 )
        <=> ( ord_less_eq(A,Xa,Y3)
            & ord_less_eq(A,Y3,Xa) ) ) ) ).

tff(fact_15_atom_Osimps_I1_J,axiom,
    ! [List3: list(int),Int1: int,List: list(int),Int: int] :
      ( ( c_PresArith_Oatom_OLe(Int,List) = c_PresArith_Oatom_OLe(Int1,List3) )
    <=> ( ( Int = Int1 )
        & ( List = List3 ) ) ) ).

tff(fact_16_list__diff__Cons__Cons,axiom,
    ! [A: $tType] :
      ( ( cl_Groups_Ominus(A)
        & zero(A) )
     => ! [Ys: list(A),Y1: A,Xs: list(A),X1: A] : ( minus_minus(list(A),cons(A,X1,Xs),cons(A,Y1,Ys)) = cons(A,minus_minus(A,X1,Y1),minus_minus(list(A),Xs,Ys)) ) ) ).

tff(fact_17__096_B_Bthesis_O_A_I_B_Bx_O_AALL_Aa_058set_Aas_O_AI_092_060_094isub_062Z_Aa_A_Ix_A_D_Axs_J_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X: int] :
        ~ ! [Xa1: atom] :
            ( pp(aa(fun(atom,bool),bool,aa(atom,fun(fun(atom,bool),bool),member(atom),Xa1),set(atom,as)))
           => i_Z(Xa1,cons(int,X,xs)) ) ).

tff(fact_18_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_19_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less_eq(A,X1,Y1)
         => ord_less_eq(A,Y1,X1) ) ) ).

tff(fact_20_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_21_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,Z)
           => ord_less_eq(A,X1,Z) ) ) ) ).

tff(fact_22_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,X1,Y1)
         => ( ord_less_eq(A,Y1,X1)
           => ( X1 = Y1 ) ) ) ) ).

tff(fact_23_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C4: A,B5: A,A4: A] :
          ( ord_less_eq(A,A4,B5)
         => ( ( B5 = C4 )
           => ord_less_eq(A,A4,C4) ) ) ) ).

tff(fact_24_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C4: A,B5: A,A4: A] :
          ( ( A4 = B5 )
         => ( ord_less_eq(A,B5,C4)
           => ord_less_eq(A,A4,C4) ) ) ) ).

tff(fact_25_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Xa: A,Y3: A] :
          ( ord_less_eq(A,Y3,Xa)
         => ( ord_less_eq(A,Xa,Y3)
          <=> ( Xa = Y3 ) ) ) ) ).

tff(fact_26_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_27_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
         => ord_less_eq(A,X1,Y1) ) ) ).

tff(fact_28_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A6,List3) )
    <=> ( ( Aa = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_29_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X: A] : ord_less_eq(B,aa(A,B,F,X),aa(A,B,G,X))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_30_set__subset__Cons,axiom,
    ! [A: $tType,Xa: A,Xsa: list(A)] : ord_less_eq(fun(A,bool),set(A,Xsa),set(A,cons(A,Xa,Xsa))) ).

tff(fact_31_set__ConsD,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A,Y3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,cons(A,Xa,Xsa))))
     => ( ( Y3 = Xa )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Y3),set(A,Xsa))) ) ) ).

tff(fact_32_int__le__induct,axiom,
    ! [P1: fun(int,bool),K: int,Ia: int] :
      ( ord_less_eq(int,Ia,K)
     => ( pp(aa(int,bool,P1,K))
       => ( ! [I: int] :
              ( ord_less_eq(int,I,K)
             => ( pp(aa(int,bool,P1,I))
               => pp(aa(int,bool,P1,minus_minus(int,I,one_one(int)))) ) )
         => pp(aa(int,bool,P1,Ia)) ) ) ) ).

tff(fact_33__096_Ili_M_Alks_J_A_058_Aset_A_Ilbounds_Aas_J_096,axiom,
    pp(aa(fun(product_prod(int,list(int)),bool),bool,aa(product_prod(int,list(int)),fun(fun(product_prod(int,list(int)),bool),bool),member(product_prod(int,list(int))),product_Pair(int,list(int),li,lks)),set(product_prod(int,list(int)),lbounds(as)))) ).

tff(fact_34__096lbounds_Aas_A_126_061_A_091_093_096,axiom,
    lbounds(as) != nil(product_prod(int,list(int))) ).

tff(fact_35_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,B1: B,F: fun(B,A),Aa: A] :
          ( ord_less_eq(A,Aa,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C1)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less_eq(A,Aa,aa(B,A,F,C1)) ) ) ) ) ).

tff(fact_36_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_37_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_38_list__diff__Nil2,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [Xs: list(A)] : ( minus_minus(list(A),Xs,nil(A)) = Xs ) ) ).

tff(fact_39_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X1: A] : ( cons(A,X1,Xs) != Xs ) ).

tff(fact_40_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs: list(A)] : ( Xs != cons(A,X1,Xs) ) ).

tff(fact_41_subsetD,axiom,
    ! [A: $tType,C1: A,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_42_equalityI,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( ord_less_eq(fun(A,bool),B3,A2)
       => ( A2 = B3 ) ) ) ).

tff(fact_43_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B7: B,A6: A,B1: B,Aa: A] :
      ( ( product_Pair(A,B,Aa,B1) = product_Pair(A,B,A6,B7) )
    <=> ( ( Aa = A6 )
        & ( B1 = B7 ) ) ) ).

tff(fact_44_split__paired__All,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ! [A3: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B4))) ) ).

tff(fact_45_neq__Nil__conv,axiom,
    ! [A: $tType,Xsa: list(A)] :
      ( ( Xsa != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xsa = cons(A,Y2,Ys1) ) ) ).

tff(fact_46_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B6: B,A5: A,B5: B,A4: A] :
      ( ( product_Pair(A,B,A4,B5) = product_Pair(A,B,A5,B6) )
     => ~ ( ( A4 = A5 )
         => ( B5 != B6 ) ) ) ).

tff(fact_47_equalityE,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B3 )
     => ~ ( ord_less_eq(fun(A,bool),A2,B3)
         => ~ ord_less_eq(fun(A,bool),B3,A2) ) ) ).

tff(fact_48_double__diff,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( ord_less_eq(fun(A,bool),B3,C3)
       => ( minus_minus(fun(A,bool),B3,minus_minus(fun(A,bool),C3,A2)) = A2 ) ) ) ).

tff(fact_49_Diff__mono,axiom,
    ! [A: $tType,B3: fun(A,bool),D2: fun(A,bool),C3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,C3)
     => ( ord_less_eq(fun(A,bool),D2,B3)
       => ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),A2,B3),minus_minus(fun(A,bool),C3,D2)) ) ) ).

tff(fact_50_subset__trans,axiom,
    ! [A: $tType,C3: fun(A,bool),B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( ord_less_eq(fun(A,bool),B3,C3)
       => ord_less_eq(fun(A,bool),A2,C3) ) ) ).

tff(fact_51_set__mp,axiom,
    ! [A: $tType,Xa: A,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B3)) ) ) ).

tff(fact_52_set__rev__mp,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
     => ( ord_less_eq(fun(A,bool),A2,B3)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B3)) ) ) ).

tff(fact_53_in__mono,axiom,
    ! [A: $tType,Xa: A,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B3)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),B3)) ) ) ).

tff(fact_54_equalityD2,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B3 )
     => ord_less_eq(fun(A,bool),B3,A2) ) ).

tff(fact_55_equalityD1,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B3 )
     => ord_less_eq(fun(A,bool),A2,B3) ) ).

tff(fact_56_set__eq__subset,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B3 )
    <=> ( ord_less_eq(fun(A,bool),A2,B3)
        & ord_less_eq(fun(A,bool),B3,A2) ) ) ).

tff(fact_57_Diff__subset,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ord_less_eq(fun(A,bool),minus_minus(fun(A,bool),A2,B3),A2) ).

tff(fact_58_subset__refl,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ord_less_eq(fun(A,bool),A2,A2) ).

tff(fact_59_subsetI,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] :
      ( ! [X: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),A2))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X),B3)) )
     => ord_less_eq(fun(A,bool),A2,B3) ) ).

tff(fact_60_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,P1: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,P1,X11))
    <=> ? [A3: A,B4: B] : pp(aa(product_prod(A,B),bool,P1,product_Pair(A,B,A3,B4))) ) ).

tff(fact_61_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A1: A,List1: list(A)] : ( Y1 != cons(A,A1,List1) ) ) ).

tff(fact_62_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,F11: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F11,product_Pair(B,C,Aa,B1)) = aa(C,A,aa(B,fun(C,A),F11,Aa),B1) ) ).

tff(fact_63_DiffE,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),minus_minus(fun(A,bool),A2,B3)))
     => ~ ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_64_DiffI,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),minus_minus(fun(A,bool),A2,B3))) ) ) ).

tff(fact_65_Diff__idemp,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ( minus_minus(fun(A,bool),minus_minus(fun(A,bool),A2,B3),B3) = minus_minus(fun(A,bool),A2,B3) ) ).

tff(fact_66_Diff__iff,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),minus_minus(fun(A,bool),A2,B3)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2))
        & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ) ).

tff(fact_67_DiffD2,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),minus_minus(fun(A,bool),A2,B3)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),B3)) ) ).

tff(fact_68_DiffD1,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool),C1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),minus_minus(fun(A,bool),A2,B3)))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),A2)) ) ).

tff(fact_69_set__diff__eq,axiom,
    ! [A: $tType,B3: fun(A,bool),A2: fun(A,bool)] : ( minus_minus(fun(A,bool),A2,B3) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,fun(A,bool),bool,member(A),A2)),combb(bool,bool,A,fNot,combc(A,fun(A,bool),bool,member(A),B3)))) ) ).

tff(fact_70_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_71_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_72_Collect__mono,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] :
      ( ! [X: A] :
          ( pp(aa(A,bool,P1,X))
         => pp(aa(A,bool,Q1,X)) )
     => ord_less_eq(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_73_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y1: A,Xs: list(A),X1: A] : ( splice(A,cons(A,X1,Xs),cons(A,Y1,Ys)) = cons(A,X1,cons(A,Y1,splice(A,Xs,Ys))) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),A2))
    <=> pp(aa(A,bool,A2,Xa)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = Xsa ) ) ).

tff(fact_78_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_79_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_80_List_Oinsert__def,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = Xsa ) )
      & ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
       => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ) ).

tff(fact_81_not__in__set__insert,axiom,
    ! [A: $tType,Xsa: list(A),Xa: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Xa),set(A,Xsa)))
     => ( insert(A,Xa,Xsa) = cons(A,Xa,Xsa) ) ) ).

tff(fact_82_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,nil(B)) = F11 ) ).

tff(fact_83_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F21: fun(B,fun(list(B),A)),F11: A] : ( list_case(A,B,F11,F21,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F21,Aa),List) ) ).

tff(fact_84_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y1: product_prod(A,B)] :
      ~ ! [A1: A,B2: B] : ( Y1 != product_Pair(A,B,A1,B2) ) ).

tff(fact_85_PairE,axiom,
    ! [A: $tType,B: $tType,P2: product_prod(A,B)] :
      ~ ! [X: A,Y: B] : ( P2 != product_Pair(A,B,X,Y) ) ).

tff(fact_86_prod__induct6,axiom,
    ! [F1: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool)] :
      ( ! [A1: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1))))),bool,P1,Xa)) ) ).

tff(fact_87_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F1: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))))] :
      ~ ! [A1: A,B2: B,C2: C,D1: D,E1: E,F2: F1] : ( Y1 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E,F1)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E,F1))),B2,product_Pair(C,product_prod(D,product_prod(E,F1)),C2,product_Pair(D,product_prod(E,F1),D1,product_Pair(E,F1,E1,F2))))) ) ).

tff(fact_88_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E))))] :
      ~ ! [A1: A,B2: B,C2: C,D1: D,E1: E] : ( Y1 != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1)))) ) ).

tff(fact_89_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),P1: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool)] :
      ( ! [A1: A,B2: B,C2: C,D1: D,E1: E] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E))),A1,product_Pair(B,product_prod(C,product_prod(D,E)),B2,product_Pair(C,product_prod(D,E),C2,product_Pair(D,E,D1,E1))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E)))),bool,P1,Xa)) ) ).

tff(fact_90_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,product_prod(C,D))),P1: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B2: B,C2: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,P1,Xa)) ) ).

tff(fact_91_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y1: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B2: B,C2: C,D1: D] : ( Y1 != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C2,D1))) ) ).

tff(fact_92_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y1: product_prod(A,product_prod(B,C))] :
      ~ ! [A1: A,B2: B,C2: C] : ( Y1 != product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B2,C2)) ) ).

tff(fact_93_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,Xa: product_prod(A,product_prod(B,C)),P1: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A1: A,B2: B,C2: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,P1,product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B2,C2))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,P1,Xa)) ) ).

tff(fact_94_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,Aa: B,C1: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C1,product_Pair(B,C,Aa,B1)) = aa(C,A,aa(B,fun(C,A),C1,Aa),B1) ) ).

tff(fact_95_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,B1: B,F: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F,B1) )
         => ( ord_less_eq(B,B1,C1)
           => ( ! [X: B,Y: B] :
                  ( ord_less_eq(B,X,Y)
                 => ord_less_eq(A,aa(B,A,F,X),aa(B,A,F,Y)) )
             => ord_less_eq(A,Aa,aa(B,A,F,C1)) ) ) ) ) ).

tff(fact_96_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C1: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less_eq(A,Aa,B1)
         => ( ( aa(A,B,F,B1) = C1 )
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less_eq(B,aa(A,B,F,Aa),C1) ) ) ) ) ).

tff(fact_97_order__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C1: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less_eq(A,Aa,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),C1)
           => ( ! [X: A,Y: A] :
                  ( ord_less_eq(A,X,Y)
                 => ord_less_eq(B,aa(A,B,F,X),aa(A,B,F,Y)) )
             => ord_less_eq(B,aa(A,B,F,Aa),C1) ) ) ) ) ).

tff(fact_98_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,Aa: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,Aa,B1) = aa(product_prod(B,C),A,F,product_Pair(B,C,Aa,B1)) ) ).

%----Arities (20)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ominus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( cl_Groups_Ominus(T_2)
     => cl_Groups_Ominus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Ominus,axiom,
    cl_Groups_Ominus(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_HOL_Obool___Groups_Ominus,axiom,
    cl_Groups_Ominus(bool) ).

tff(arity_List_Olist___Groups_Ominus,axiom,
    ! [T_1: $tType] :
      ( ( zero(T_1)
        & cl_Groups_Ominus(T_1) )
     => cl_Groups_Ominus(list(T_1)) ) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ord_less_eq(int,minus_minus(int,li,iprod(int,lks,xs)),x) ).

%------------------------------------------------------------------------------
